/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.graph;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import schemacrawler.test.graph.GraphTestBase;
import schemacrawler.test.utility.TestName;
import sf.util.graph.DirectedGraph;

public class DirectedGraphTest5
extends GraphTestBase {
    @Rule
    public TestName testName = new TestName();

    @Test
    public void cycle2() throws Exception {
        DirectedGraph graph = new DirectedGraph(this.testName.currentMethodFullName());
        graph.addEdge((Comparable)((Object)"A"), (Comparable)((Object)"B"));
        graph.addEdge((Comparable)((Object)"B"), (Comparable)((Object)"A"));
        Assert.assertTrue((boolean)this.containsCycleSimple(graph));
        Assert.assertTrue((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void cycle3() throws Exception {
        DirectedGraph graph = new DirectedGraph(this.testName.currentMethodFullName());
        graph.addEdge((Comparable)((Object)"A"), (Comparable)((Object)"B"));
        graph.addEdge((Comparable)((Object)"B"), (Comparable)((Object)"C"));
        graph.addEdge((Comparable)((Object)"C"), (Comparable)((Object)"A"));
        Assert.assertTrue((boolean)this.containsCycleSimple(graph));
        Assert.assertTrue((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void cycle3WithStub() throws Exception {
        DirectedGraph graph = new DirectedGraph(this.testName.currentMethodFullName());
        graph.addEdge((Comparable)((Object)"A"), (Comparable)((Object)"B"));
        graph.addEdge((Comparable)((Object)"B"), (Comparable)((Object)"C"));
        graph.addEdge((Comparable)((Object)"C"), (Comparable)((Object)"A"));
        graph.addEdge((Comparable)((Object)"C"), (Comparable)((Object)"D"));
        Assert.assertTrue((boolean)this.containsCycleSimple(graph));
        Assert.assertTrue((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void linear2() throws Exception {
        DirectedGraph graph = new DirectedGraph(this.testName.currentMethodFullName());
        graph.addEdge((Comparable)((Object)"A"), (Comparable)((Object)"B"));
        Assert.assertFalse((boolean)this.containsCycleSimple(graph));
        Assert.assertFalse((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void linear3() throws Exception {
        DirectedGraph graph = new DirectedGraph(this.testName.currentMethodFullName());
        graph.addEdge((Comparable)((Object)"A"), (Comparable)((Object)"B"));
        graph.addEdge((Comparable)((Object)"B"), (Comparable)((Object)"C"));
        Assert.assertFalse((boolean)this.containsCycleSimple(graph));
        Assert.assertFalse((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void twoConnected3Cycles() throws Exception {
        DirectedGraph graph = new DirectedGraph(this.testName.currentMethodFullName());
        graph.addEdge((Comparable)((Object)"A"), (Comparable)((Object)"B"));
        graph.addEdge((Comparable)((Object)"B"), (Comparable)((Object)"C"));
        graph.addEdge((Comparable)((Object)"C"), (Comparable)((Object)"A"));
        graph.addEdge((Comparable)((Object)"D"), (Comparable)((Object)"E"));
        graph.addEdge((Comparable)((Object)"E"), (Comparable)((Object)"F"));
        graph.addEdge((Comparable)((Object)"F"), (Comparable)((Object)"D"));
        graph.addEdge((Comparable)((Object)"B"), (Comparable)((Object)"D"));
        Assert.assertTrue((boolean)this.containsCycleSimple(graph));
        Assert.assertTrue((boolean)this.containsCycleTarjan(graph));
    }

    @Test
    public void twoIsolated3Cycles() throws Exception {
        DirectedGraph graph = new DirectedGraph(this.testName.currentMethodFullName());
        graph.addEdge((Comparable)((Object)"A"), (Comparable)((Object)"B"));
        graph.addEdge((Comparable)((Object)"B"), (Comparable)((Object)"C"));
        graph.addEdge((Comparable)((Object)"C"), (Comparable)((Object)"A"));
        graph.addEdge((Comparable)((Object)"D"), (Comparable)((Object)"E"));
        graph.addEdge((Comparable)((Object)"E"), (Comparable)((Object)"F"));
        graph.addEdge((Comparable)((Object)"F"), (Comparable)((Object)"D"));
        Assert.assertTrue((boolean)this.containsCycleSimple(graph));
        Assert.assertTrue((boolean)this.containsCycleTarjan(graph));
    }
}

