/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.graph;

import java.util.Collection;
import java.util.List;
import sf.util.graph.DirectedGraph;
import sf.util.graph.GraphException;
import sf.util.graph.SimpleCycleDetector;
import sf.util.graph.SimpleTopologicalSort;
import sf.util.graph.TarjanStronglyConnectedComponentFinder;

abstract class GraphTestBase {
    private final boolean DEBUG = false;

    GraphTestBase() {
    }

    protected <T extends Comparable<? super T>> boolean containsCycleSimple(DirectedGraph<T> graph) {
        boolean containsCycle = new SimpleCycleDetector(graph).containsCycle();
        return containsCycle;
    }

    protected <T extends Comparable<? super T>> boolean containsCycleTarjan(DirectedGraph<T> graph) {
        Collection sccs = new TarjanStronglyConnectedComponentFinder(graph).detectCycles();
        return !sccs.isEmpty();
    }

    protected <T extends Comparable<? super T>> List<T> topologicalSort(DirectedGraph<T> graph) throws GraphException {
        return new SimpleTopologicalSort(graph).topologicalSort();
    }
}

