/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.DatabaseConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.schemacrawler.SingleUseUserCredentials;
import schemacrawler.schemacrawler.UserCredentials;
import schemacrawler.test.utility.BaseSchemaCrawlerTest;
import schemacrawler.testdb.TestDatabase;

public abstract class BaseDatabaseTest
extends BaseSchemaCrawlerTest {
    protected Catalog getCatalog(SchemaCrawlerOptions schemaCrawlerOptions) throws SchemaCrawlerException {
        return this.getCatalog(SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions(), schemaCrawlerOptions);
    }

    protected Catalog getCatalog(SchemaRetrievalOptions schemaRetrievalOptions, SchemaCrawlerOptions schemaCrawlerOptions) throws SchemaCrawlerException {
        this.createDataSource();
        SchemaCrawler schemaCrawler = new SchemaCrawler(this.getConnection(), schemaRetrievalOptions, schemaCrawlerOptions);
        Catalog catalog = schemaCrawler.crawl();
        return catalog;
    }

    protected Connection getConnection() throws SchemaCrawlerException {
        try {
            return this.createDataSource().getConnection();
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException(e.getMessage(), (Throwable)e);
        }
    }

    protected Config loadConfigFromClasspathResource(String resource) throws IOException {
        InputStream stream = BaseDatabaseTest.class.getResourceAsStream(resource);
        Objects.requireNonNull(stream, "Could not load config from resource, " + resource);
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        Properties properties = new Properties();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            properties.load(bufferedReader);
        }
        return new Config(properties);
    }

    protected Config loadHsqldbConfig() throws IOException {
        return this.loadConfigFromClasspathResource("/hsqldb.INFORMATION_SCHEMA.config.properties");
    }

    private ConnectionOptions createDataSource() throws SchemaCrawlerException {
        SingleUseUserCredentials userCredentials = new SingleUseUserCredentials("sa", "");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", "jdbc:hsqldb:hsql://localhost/schemacrawler");
        DatabaseConnectionOptions connectionOptions = new DatabaseConnectionOptions((UserCredentials)userCredentials, map);
        return connectionOptions;
    }

    static {
        TestDatabase.initialize();
    }
}

