/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import schemacrawler.test.utility.TestOutputCapture;
import schemacrawler.test.utility.TestUtility;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.tools.iosource.FileInputResource;
import schemacrawler.tools.iosource.InputResource;
import sf.util.Utility;

public class FileHasContent
extends BaseMatcher<InputResource> {
    private final InputResource referenceFileResource;
    private final String outputFormatValue;
    private List<String> failures;

    public static InputResource classpathResource(String classpathResource) {
        try {
            Objects.requireNonNull(classpathResource, "No classpath resource provided");
            return new ClasspathInputResource("/" + classpathResource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InputResource fileResource(TestOutputCapture testoutput) {
        Objects.requireNonNull(testoutput, "No test output cature provided");
        Path filePath = testoutput.getFilePath();
        try {
            return FileInputResource.allowEmptyFileInputResource((Path)filePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Factory
    public static Matcher<InputResource> hasNoContent() {
        return new FileHasContent(null, null);
    }

    @Factory
    public static Matcher<InputResource> hasSameContentAndTypeAs(InputResource classpathInputResource, String outputFormatValue) {
        if (classpathInputResource == null || !(classpathInputResource instanceof ClasspathInputResource)) {
            throw new RuntimeException("No classpath resource to match with");
        }
        if (Utility.isBlank((CharSequence)outputFormatValue)) {
            throw new RuntimeException("No output format provided");
        }
        return new FileHasContent(classpathInputResource, outputFormatValue);
    }

    @Factory
    public static Matcher<InputResource> hasSameContentAs(InputResource classpathInputResource) {
        if (classpathInputResource == null || !(classpathInputResource instanceof ClasspathInputResource)) {
            throw new RuntimeException("No file resource to match with");
        }
        return new FileHasContent(classpathInputResource, null);
    }

    public FileHasContent(InputResource referenceFileResource, String outputFormatValue) {
        this.referenceFileResource = referenceFileResource;
        this.outputFormatValue = outputFormatValue;
    }

    public void describeMismatch(Object item, Description description) {
        if (this.failures != null) {
            description.appendValueList("mismatched on:\n", "\n", "", this.failures);
        }
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.referenceFileResource);
    }

    public boolean matches(Object actualValue) {
        try {
            this.failures = null;
            String referenceFile = this.getReferenceFile();
            Path file = this.getFilePath(actualValue);
            if (Utility.isBlank((CharSequence)referenceFile)) {
                return !Files.exists(file, new LinkOption[0]) || Files.size(file) == 0L;
            }
            String outputFormatValue = this.getNonNullOutputFormatValue();
            this.failures = TestUtility.compareOutput(referenceFile, file, outputFormatValue, false);
            return this.failures != null && this.failures.isEmpty();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Path getFilePath(Object actualValue) {
        if (actualValue == null || !(actualValue instanceof FileInputResource)) {
            throw new RuntimeException("No file input resource provided");
        }
        Path file = ((FileInputResource)actualValue).getInputFile();
        return file;
    }

    private String getNonNullOutputFormatValue() {
        String outputFormatValue = Utility.isBlank((CharSequence)this.outputFormatValue) ? "text" : this.outputFormatValue;
        return outputFormatValue;
    }

    private String getReferenceFile() {
        String referenceFile = this.referenceFileResource == null ? null : ((ClasspathInputResource)this.referenceFileResource).getClasspathResource().substring(1);
        return referenceFile;
    }
}

