/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import schemacrawler.schemacrawler.Config;
import sf.util.IOUtility;
import sf.util.Utility;

public final class TestUtility {
    private static final Pattern[] neuters = new Pattern[]{Pattern.compile("url +jdbc:.*"), Pattern.compile("database product version.*"), Pattern.compile("driver version.*"), Pattern.compile("-- operating system:.*"), Pattern.compile("-- JVM system:.*"), Pattern.compile("\\s+<schemaCrawler(Version|About|Info)>.*"), Pattern.compile("\\s+\"runId\": .*"), Pattern.compile("\\s+<product(Name|Version)>.*"), Pattern.compile(".*[A-Za-z]+ \\d+\\, 201[456] \\d+:\\d+ [AP]M.*"), Pattern.compile(".*201[6-8]-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d.*"), Pattern.compile(".*201[6-8]-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d\\.\\d\\d\\d.*"), Pattern.compile("SQL\\d+\\s+\\[primary key\\]"), Pattern.compile("SQL\\d+\\s+\\[foreign key, with no action\\]"), Pattern.compile("<svg.*"), Pattern.compile(" viewBox=\"0.00.*"), Pattern.compile("<g id=.*"), Pattern.compile("<text text-anchor.*"), Pattern.compile("<path fill=.*"), Pattern.compile("<(ellipse|polyline|polygon) fill=.*"), Pattern.compile(".*&#xd;")};

    public static void clean(String dirname) throws Exception {
        FileUtils.deleteDirectory((File)TestUtility.buildDirectory().resolve("unit_tests_results_output").resolve(dirname).toFile());
    }

    public static List<String> compareCompressedOutput(String referenceFile, Path testOutputTempFile, String outputFormat) throws Exception {
        return TestUtility.compareOutput(referenceFile, testOutputTempFile, outputFormat, true);
    }

    public static List<String> compareOutput(String referenceFile, Path testOutputTempFile, String outputFormat) throws Exception {
        return TestUtility.compareOutput(referenceFile, testOutputTempFile, outputFormat, false);
    }

    public static List<String> compareOutput(String referenceFile, Path testOutputTempFile, String outputFormat, boolean isCompressed) throws Exception {
        boolean contentEquals;
        Objects.requireNonNull(referenceFile, "Reference file is not defined");
        Objects.requireNonNull(testOutputTempFile, "Output file is not defined");
        Objects.requireNonNull(outputFormat, "Output format is not defined");
        if (!IOUtility.isFileReadable((Path)testOutputTempFile)) {
            return Collections.singletonList("Output file not created - " + testOutputTempFile);
        }
        ArrayList<String> failures = new ArrayList<String>();
        Reader referenceReader = TestUtility.readerForResource(referenceFile, StandardCharsets.UTF_8, isCompressed);
        if (referenceReader == null) {
            contentEquals = false;
        } else {
            Reader fileReader = TestUtility.readerForFile(testOutputTempFile, isCompressed);
            contentEquals = TestUtility.contentEquals(referenceReader, fileReader, failures, neuters);
        }
        if ("html".equals(outputFormat)) {
            TestUtility.validateXML(testOutputTempFile, failures);
        }
        if ("htmlx".equals(outputFormat)) {
            TestUtility.validateXML(testOutputTempFile, failures);
        } else if ("json".equals(outputFormat)) {
            TestUtility.validateJSON(testOutputTempFile, failures);
        }
        if (!contentEquals) {
            Path testOutputTargetFilePath = TestUtility.buildDirectory().resolve("unit_tests_results_output").resolve(referenceFile);
            Files.createDirectories(testOutputTargetFilePath.getParent(), new FileAttribute[0]);
            Files.deleteIfExists(testOutputTargetFilePath);
            Files.move(testOutputTempFile, testOutputTargetFilePath, StandardCopyOption.REPLACE_EXISTING);
            if (!contentEquals) {
                failures.add("Output does not match");
            }
            failures.add("Actual output in " + testOutputTargetFilePath);
            System.err.println(testOutputTargetFilePath);
        } else {
            Files.delete(testOutputTempFile);
        }
        return failures;
    }

    public static Path copyResourceToTempFile(String resource) throws IOException {
        if (Utility.isBlank((CharSequence)resource)) {
            throw new IOException("Cannot read empty resource");
        }
        try (InputStream resourceStream = TestUtility.class.getResourceAsStream(resource);){
            Objects.requireNonNull(resourceStream, "Resource not found, " + resource);
            Path path = TestUtility.writeToTempFile(resourceStream);
            return path;
        }
    }

    public static String[] flattenCommandlineArgs(Map<String, String> argsMap) {
        ArrayList<String> argsList = new ArrayList<String>();
        for (Map.Entry<String, String> arg : argsMap.entrySet()) {
            String key = arg.getKey();
            String value = arg.getValue();
            if (value != null) {
                argsList.add(String.format("-%s=%s", key, value));
                continue;
            }
            argsList.add(String.format("-%s", key));
        }
        String[] args = argsList.toArray(new String[0]);
        return args;
    }

    public static Reader readerForResource(String resource, Charset encoding) throws IOException {
        return TestUtility.readerForResource(resource, encoding, false);
    }

    public static void validateDiagram(Path diagramFile) throws IOException {
        Assert.assertTrue((String)"Diagram file not created", (boolean)Files.exists(diagramFile, new LinkOption[0]));
        Assert.assertTrue((String)"Diagram file has 0 bytes size", (Files.size(diagramFile) > 0L ? 1 : 0) != 0);
    }

    public static Path writeConfigToTempFile(Config config) throws IOException {
        Objects.requireNonNull(config, "No properties provided");
        Path tempFile = IOUtility.createTempFilePath((String)"output", (String)"data").normalize().toAbsolutePath();
        BufferedWriter tempFileWriter = Files.newBufferedWriter(tempFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        config.toProperties().store(tempFileWriter, "Store config to temporary file for testing");
        return tempFile;
    }

    private static Path buildDirectory() throws Exception {
        StackTraceElement ste = TestUtility.currentMethodStackTraceElement();
        Class<?> callingClass = Class.forName(ste.getClassName());
        Path codePath = Paths.get(callingClass.getProtectionDomain().getCodeSource().getLocation().toURI()).normalize().toAbsolutePath();
        boolean isInTarget = codePath.toString().contains("target");
        if (!isInTarget) {
            throw new RuntimeException("Not in build directory, " + codePath);
        }
        Path directory = codePath.resolve("..");
        return directory.normalize().toAbsolutePath();
    }

    /*
     * Exception decompiling
     */
    private static boolean contentEquals(Reader expectedInputReader, Reader actualInputReader, List<String> failures, Pattern ... ignoreLinePatterns) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 46[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static StackTraceElement currentMethodStackTraceElement() {
        Pattern baseTestClassName = Pattern.compile(".*\\.Base.*Test");
        Pattern testClassName = Pattern.compile(".*\\.[A-Z].*Test");
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String className = stackTraceElement.getClassName();
            if (!testClassName.matcher(className).matches() || baseTestClassName.matcher(className).matches()) continue;
            return stackTrace[i];
        }
        return null;
    }

    private static void fastChannelCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    private static Reader openNewCompressedInputReader(InputStream inputStream, Charset charset) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        zipInputStream.getNextEntry();
        return new InputStreamReader((InputStream)zipInputStream, charset);
    }

    private static Reader readerForFile(Path testOutputTempFile) throws IOException {
        return TestUtility.readerForFile(testOutputTempFile, false);
    }

    private static Reader readerForFile(Path testOutputTempFile, boolean isCompressed) throws IOException {
        BufferedReader bufferedReader;
        if (isCompressed) {
            ZipInputStream inputStream = new ZipInputStream(Files.newInputStream(testOutputTempFile, StandardOpenOption.READ));
            inputStream.getNextEntry();
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
        } else {
            bufferedReader = Files.newBufferedReader(testOutputTempFile, StandardCharsets.UTF_8);
        }
        return bufferedReader;
    }

    private static Reader readerForResource(String resource, Charset encoding, boolean isCompressed) throws IOException {
        Reader reader;
        InputStream inputStream = TestUtility.class.getResourceAsStream("/" + resource);
        if (inputStream != null) {
            Charset charset = encoding == null ? StandardCharsets.UTF_8 : encoding;
            reader = isCompressed ? TestUtility.openNewCompressedInputReader(inputStream, charset) : new InputStreamReader(inputStream, charset);
        } else {
            reader = null;
        }
        return reader;
    }

    private static boolean validateJSON(Path testOutputFile, List<String> failures) throws FileNotFoundException, SAXException, IOException {
        JsonElement jsonElement;
        try (Reader reader = TestUtility.readerForFile(testOutputFile);
             JsonReader jsonReader = new JsonReader(reader);){
            jsonElement = new JsonParser().parse(jsonReader);
            if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                failures.add("JSON document was not fully consumed.");
            }
        }
        catch (Exception e) {
            failures.add(e.getMessage());
            return false;
        }
        int size = jsonElement.isJsonObject() ? jsonElement.getAsJsonObject().entrySet().size() : (jsonElement.isJsonArray() ? jsonElement.getAsJsonArray().size() : 0);
        if (size == 0) {
            failures.add("Invalid JSON string");
        }
        return failures.isEmpty();
    }

    private static void validateXML(Path testOutputFile, final List<String> failures) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                failures.add(e.getMessage());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                failures.add(e.getMessage());
            }

            @Override
            public void warning(SAXParseException e) throws SAXException {
                failures.add(e.getMessage());
            }
        });
        builder.parse(new InputSource(TestUtility.readerForFile(testOutputFile)));
    }

    private static Path writeToTempFile(InputStream resourceStream) throws IOException, FileNotFoundException {
        Path tempFile = IOUtility.createTempFilePath((String)"resource", (String)"data").normalize().toAbsolutePath();
        try (OutputStream tempFileStream = Files.newOutputStream(tempFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            TestUtility.fastChannelCopy(Channels.newChannel(resourceStream), Channels.newChannel(tempFileStream));
        }
        return tempFile;
    }

    private TestUtility() {
    }
}

