/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import schemacrawler.test.utility.TestOutputCapture;
import schemacrawler.test.utility.TestOutputStream;

public final class TestWriter
extends Writer
implements TestOutputCapture {
    private static final String lineSeparator = System.getProperty("line.separator");
    private final TestOutputStream out = new TestOutputStream();

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public Path getFilePath() {
        return this.out.getFilePath();
    }

    @Override
    public String getFileContents() {
        return this.out.getFileContents();
    }

    public void println() {
        this.writeout(lineSeparator);
    }

    public void println(Object x) {
        if (x == null) {
            this.println("null");
        } else {
            this.println(x.toString());
        }
    }

    public void println(String x) {
        this.writeout(x);
        this.println();
    }

    public String toString() {
        return this.out.toString();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writeout(new String(cbuf, off, len));
    }

    private void writeout(String x) {
        try {
            if (x == null) {
                this.out.write("null".getBytes(StandardCharsets.UTF_8));
            } else {
                this.out.write(x.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

