/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler;

import java.util.Objects;
import schemacrawler.ProductVersion;

public class BaseProductVersion
implements ProductVersion {
    private static final long serialVersionUID = 4051323422934251828L;
    private final String productName;
    private final String productVersion;

    public BaseProductVersion(ProductVersion productVersion) {
        this(Objects.requireNonNull(productVersion, "No product name provided").getProductName(), productVersion.getProductVersion());
    }

    public BaseProductVersion(String productName, String productVersion) {
        this.productName = Objects.requireNonNull(productName, "No product name provided");
        this.productVersion = Objects.requireNonNull(productVersion, "No product version provided");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseProductVersion)) {
            return false;
        }
        BaseProductVersion other = (BaseProductVersion)obj;
        if (this.productName == null ? other.productName != null : !this.productName.equals(other.productName)) {
            return false;
        }
        return !(this.productVersion == null ? other.productVersion != null : !this.productVersion.equals(other.productVersion));
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.productName == null ? 0 : this.productName.hashCode());
        result = 31 * result + (this.productVersion == null ? 0 : this.productVersion.hashCode());
        return result;
    }

    public String toString() {
        return String.format("%s %s", this.productName, this.productVersion);
    }
}

