/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;

public abstract class BaseColumnReference
implements ColumnReference,
Comparable<ColumnReference> {
    private static final long serialVersionUID = -4411771492159843382L;
    private final Column foreignKeyColumn;
    private final Column primaryKeyColumn;

    protected BaseColumnReference(Column primaryKeyColumn, Column foreignKeyColumn) {
        this.primaryKeyColumn = Objects.requireNonNull(primaryKeyColumn, "No primary key column provided");
        this.foreignKeyColumn = Objects.requireNonNull(foreignKeyColumn, "No foreign key column provided");
    }

    @Override
    public int compareTo(ColumnReference columnRef) {
        if (columnRef == null) {
            return -1;
        }
        int compare = 0;
        if (compare == 0) {
            compare = this.primaryKeyColumn.getFullName().compareTo(columnRef.getPrimaryKeyColumn().getFullName());
        }
        if (compare == 0) {
            compare = this.foreignKeyColumn.getFullName().compareTo(columnRef.getForeignKeyColumn().getFullName());
        }
        return compare;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        ColumnReference other = (ColumnReference)obj;
        if (this.foreignKeyColumn == null ? other.getForeignKeyColumn() != null : !this.foreignKeyColumn.equals(other.getForeignKeyColumn())) {
            return false;
        }
        return !(this.primaryKeyColumn == null ? other.getPrimaryKeyColumn() != null : !this.primaryKeyColumn.equals(other.getPrimaryKeyColumn()));
    }

    @Override
    public Column getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    @Override
    public Column getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.foreignKeyColumn == null ? 0 : this.foreignKeyColumn.hashCode());
        result = 31 * result + (this.primaryKeyColumn == null ? 0 : this.primaryKeyColumn.hashCode());
        return result;
    }

    public String toString() {
        return this.primaryKeyColumn + " <-- " + this.foreignKeyColumn;
    }
}

