/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ImmutableDatabaseProperty;
import schemacrawler.crawl.ImmutableJdbcDriverProperty;
import schemacrawler.crawl.ImmutableServerInfoProperty;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableDatabaseInfo;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schema.SearchableType;
import schemacrawler.schemacrawler.IncludeAll;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.utility.Query;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class DatabaseInfoRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(DatabaseInfoRetriever.class.getName());
    private static final List<String> ignoreMethods = Arrays.asList("getDatabaseProductName", "getDatabaseProductVersion", "getURL", "getUserName", "getDriverName", "getDriverVersion");

    private static boolean isDatabasePropertiesResultSetMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        boolean isPropertiesResultSetMethod = returnType.equals(ResultSet.class) && method.getParameterTypes().length == 0;
        return isPropertiesResultSetMethod;
    }

    private static boolean isDatabasePropertyListMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        boolean isDatabasePropertyListMethod = returnType.equals(String.class) && method.getName().endsWith("s") && method.getParameterTypes().length == 0;
        return isDatabasePropertyListMethod;
    }

    private static boolean isDatabasePropertyMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        boolean notPropertyMethod = returnType.equals(ResultSet.class) || returnType.equals(Connection.class) || method.getParameterTypes().length > 0;
        return !notPropertyMethod;
    }

    private static boolean isDatabasePropertyResultSetType(Method method) {
        Object[] databasePropertyResultSetTypes = new String[]{"deletesAreDetected", "insertsAreDetected", "updatesAreDetected", "othersDeletesAreVisible", "othersInsertsAreVisible", "othersUpdatesAreVisible", "ownDeletesAreVisible", "ownInsertsAreVisible", "ownUpdatesAreVisible", "supportsResultSetType"};
        boolean isDatabasePropertyResultSetType = Arrays.binarySearch(databasePropertyResultSetTypes, method.getName()) >= 0;
        return isDatabasePropertyResultSetType;
    }

    private static ImmutableDatabaseProperty retrieveResultSetTypeProperty(DatabaseMetaData dbMetaData, Method method, int resultSetType, String resultSetTypeName) throws IllegalAccessException, InvocationTargetException {
        String name = method.getName() + "For" + resultSetTypeName + "ResultSets";
        Boolean propertyValue = (Boolean)method.invoke((Object)dbMetaData, resultSetType);
        return new ImmutableDatabaseProperty(name, (Object)propertyValue);
    }

    DatabaseInfoRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveAdditionalDatabaseInfo() {
        Method[] methods;
        DatabaseMetaData dbMetaData = this.getMetaData();
        MutableDatabaseInfo dbInfo = this.catalog.getDatabaseInfo();
        ArrayList<ImmutableDatabaseProperty> dbProperties = new ArrayList<ImmutableDatabaseProperty>();
        for (Method method : methods = DatabaseMetaData.class.getMethods()) {
            try {
                Object value;
                if (ignoreMethods.contains(method.getName())) continue;
                if (DatabaseInfoRetriever.isDatabasePropertyListMethod(method)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINER, new StringFormat("Retrieving database property using method <%s>", method));
                    }
                    String[] list = (value = (String)method.invoke((Object)dbMetaData, new Object[0])) == null ? new String[]{} : ((String)value).split(",");
                    dbProperties.add(new ImmutableDatabaseProperty(method.getName(), Arrays.asList(list)));
                    continue;
                }
                if (DatabaseInfoRetriever.isDatabasePropertyMethod(method)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINER, new StringFormat("Retrieving database property using method <%s>", method));
                    }
                    value = method.invoke((Object)dbMetaData, new Object[0]);
                    dbProperties.add(new ImmutableDatabaseProperty(method.getName(), value));
                    continue;
                }
                if (DatabaseInfoRetriever.isDatabasePropertiesResultSetMethod(method)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINER, new StringFormat("Retrieving database property using method <%s>", method));
                    }
                    ResultSet results = (ResultSet)method.invoke((Object)dbMetaData, new Object[0]);
                    List<String> resultsList = DatabaseUtility.readResultsVector(results);
                    dbProperties.add(new ImmutableDatabaseProperty(method.getName(), resultsList.toArray(new String[resultsList.size()])));
                    continue;
                }
                if (!DatabaseInfoRetriever.isDatabasePropertyResultSetType(method)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINER, new StringFormat("Retrieving database property using method <%s>", method));
                }
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1003, "TYPE_FORWARD_ONLY"));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1004, "TYPE_SCROLL_INSENSITIVE"));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1005, "TYPE_SCROLL_SENSITIVE"));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.log(Level.FINE, new StringFormat("Could not execute method <%s>", method), e.getCause());
            }
            catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
                this.logSQLFeatureNotSupported(new StringFormat("Could not execute method %s", method), e);
            }
            catch (SQLException e) {
                this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not execute method %s", method), e);
            }
        }
        dbInfo.addAll(dbProperties);
    }

    void retrieveAdditionalJdbcDriverInfo() {
        MutableJdbcDriverInfo driverInfo = this.catalog.getJdbcDriverInfo();
        if (driverInfo == null) {
            return;
        }
        try {
            DriverPropertyInfo[] propertyInfo;
            DatabaseMetaData dbMetaData = this.getMetaData();
            String url = dbMetaData.getURL();
            Driver jdbcDriver = DriverManager.getDriver(url);
            for (DriverPropertyInfo driverPropertyInfo : propertyInfo = jdbcDriver.getPropertyInfo(url, new Properties())) {
                driverInfo.addJdbcDriverProperty(new ImmutableJdbcDriverProperty(driverPropertyInfo));
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain JDBC driver information", (Throwable)e);
        }
    }

    void retrieveCrawlInfo(String title) {
        this.catalog.setCrawlInfo(title);
    }

    void retrieveDatabaseInfo() {
        MutableDatabaseInfo dbInfo = this.catalog.getDatabaseInfo();
        if (dbInfo == null) {
            return;
        }
        try {
            DatabaseMetaData dbMetaData = this.getMetaData();
            dbInfo.setUserName(dbMetaData.getUserName());
            dbInfo.setProductName(dbMetaData.getDatabaseProductName());
            dbInfo.setProductVersion(dbMetaData.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain database information", (Throwable)e);
            return;
        }
    }

    void retrieveJdbcDriverInfo() {
        MutableJdbcDriverInfo driverInfo = this.catalog.getJdbcDriverInfo();
        if (driverInfo == null) {
            return;
        }
        try {
            DatabaseMetaData dbMetaData = this.getMetaData();
            String url = dbMetaData.getURL();
            driverInfo.setDriverName(dbMetaData.getDriverName());
            driverInfo.setDriverVersion(dbMetaData.getDriverVersion());
            driverInfo.setConnectionUrl(url);
            Driver jdbcDriver = DriverManager.getDriver(url);
            driverInfo.setJdbcDriverClassName(jdbcDriver.getClass().getName());
            driverInfo.setJdbcCompliant(jdbcDriver.jdbcCompliant());
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain JDBC driver information", (Throwable)e);
        }
    }

    void retrieveServerInfo() {
        MutableDatabaseInfo dbInfo = this.catalog.getDatabaseInfo();
        if (dbInfo == null) {
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.SERVER_INFORMATION)) {
            LOGGER.log(Level.INFO, "Not retrieving server information, since this was not requested");
            LOGGER.log(Level.FINE, "Server information SQL statement was not provided");
            return;
        }
        Query serverInfoSql = informationSchemaViews.getQuery(InformationSchemaKey.SERVER_INFORMATION);
        Connection connection = this.getDatabaseConnection();
        try (Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(serverInfoSql, statement, new IncludeAll());){
            results.setDescription("retrieveServerInfo");
            while (results.next()) {
                String propertyName = results.getString("NAME");
                if (Utility.isBlank(propertyName)) continue;
                LOGGER.log(Level.FINER, new StringFormat("Retrieving server information property: %s", propertyName));
                String propertyValue = results.getString("VALUE");
                String propertyDescription = results.getString("DESCRIPTION");
                ImmutableServerInfoProperty serverInfoProperty = new ImmutableServerInfoProperty(propertyName, propertyValue, propertyDescription);
                dbInfo.addServerInfo(serverInfoProperty);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional column attributes", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveSystemColumnDataTypes() throws SQLException {
        MetadataResultSet results;
        Statement statement;
        SchemaReference systemSchema = new SchemaReference();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (informationSchemaViews.hasQuery(InformationSchemaKey.OVERRIDE_TYPE_INFO)) {
            Query typeInfoSql = informationSchemaViews.getQuery(InformationSchemaKey.OVERRIDE_TYPE_INFO);
            Connection connection = this.getDatabaseConnection();
            statement = connection.createStatement();
            results = new MetadataResultSet(typeInfoSql, statement, this.getSchemaInclusionRule());
        } else {
            statement = null;
            results = new MetadataResultSet(this.getMetaData().getTypeInfo());
        }
        try {
            while (results.next()) {
                String typeName = results.getString("TYPE_NAME");
                int dataType = results.getInt("DATA_TYPE", 0);
                LOGGER.log(Level.FINER, new StringFormat("Retrieving data type <%s> with type id %d", typeName, dataType));
                long precision = results.getLong("PRECISION", 0L);
                String literalPrefix = results.getString("LITERAL_PREFIX");
                String literalSuffix = results.getString("LITERAL_SUFFIX");
                String createParameters = results.getString("CREATE_PARAMS");
                boolean isNullable = results.getInt("NULLABLE", 2) == 1;
                boolean isCaseSensitive = results.getBoolean("CASE_SENSITIVE");
                SearchableType searchable = results.getEnumFromId("SEARCHABLE", SearchableType.unknown);
                boolean isUnsigned = results.getBoolean("UNSIGNED_ATTRIBUTE");
                boolean isFixedPrecisionScale = results.getBoolean("FIXED_PREC_SCALE");
                boolean isAutoIncremented = results.getBoolean("AUTO_INCREMENT");
                String localTypeName = results.getString("LOCAL_TYPE_NAME");
                int minimumScale = results.getInt("MINIMUM_SCALE", 0);
                int maximumScale = results.getInt("MAXIMUM_SCALE", 0);
                int numPrecisionRadix = results.getInt("NUM_PREC_RADIX", 0);
                MutableColumnDataType columnDataType = this.lookupOrCreateColumnDataType(systemSchema, dataType, typeName);
                columnDataType.setPrecision(precision);
                columnDataType.setLiteralPrefix(literalPrefix);
                columnDataType.setLiteralSuffix(literalSuffix);
                columnDataType.setCreateParameters(createParameters);
                columnDataType.setNullable(isNullable);
                columnDataType.setCaseSensitive(isCaseSensitive);
                columnDataType.setSearchable(searchable);
                columnDataType.setUnsigned(isUnsigned);
                columnDataType.setFixedPrecisionScale(isFixedPrecisionScale);
                columnDataType.setAutoIncrementable(isAutoIncremented);
                columnDataType.setLocalTypeName(localTypeName);
                columnDataType.setMinimumScale(minimumScale);
                columnDataType.setMaximumScale(maximumScale);
                columnDataType.setNumPrecisionRadix(numPrecisionRadix);
                columnDataType.addAttributes(results.getAttributes());
                this.catalog.addColumnDataType(columnDataType);
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    void retrieveUserDefinedColumnDataTypes(Schema schema) throws SQLException {
        Objects.requireNonNull(schema, "No schema provided");
        Optional<SchemaReference> schemaOptional = this.catalog.lookupSchema(schema.getFullName());
        if (!schemaOptional.isPresent()) {
            LOGGER.log(Level.INFO, new StringFormat("Cannot locate schema, so not retrieving data types for schema: %s", schema));
            return;
        }
        LOGGER.log(Level.INFO, new StringFormat("Retrieving data types for schema <%s>", schema));
        String catalogName = schema.getCatalogName();
        String schemaName = schema.getName();
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getUDTs(catalogName, schemaName, "%", null));){
            while (results.next()) {
                String typeName = results.getString("TYPE_NAME");
                LOGGER.log(Level.FINE, new StringFormat("Retrieving data type <%s.%s>", schema, typeName));
                int dataType = results.getInt("DATA_TYPE", 0);
                String className = results.getString("CLASS_NAME");
                String remarks = results.getString("REMARKS");
                short baseTypeValue = results.getShort("BASE_TYPE", (short)0);
                MutableColumnDataType baseType = baseTypeValue != 0 ? this.catalog.lookupColumnDataTypeByType(baseTypeValue) : null;
                MutableColumnDataType columnDataType = this.lookupOrCreateColumnDataType(schema, dataType, typeName, className);
                columnDataType.setUserDefined(true);
                columnDataType.setBaseType(baseType);
                columnDataType.setRemarks(remarks);
                columnDataType.addAttributes(results.getAttributes());
                this.catalog.addColumnDataType(columnDataType);
            }
        }
    }
}

