/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.io.Serializable;
import java.sql.SQLType;
import java.util.Objects;
import schemacrawler.schema.JavaSqlTypeGroup;

public final class JavaSqlType
implements SQLType,
Serializable,
Comparable<JavaSqlType> {
    private static final long serialVersionUID = 2614819974745473431L;
    public static final JavaSqlType UNKNOWN = new JavaSqlType(Integer.MAX_VALUE, "<UNKNOWN>", Object.class, JavaSqlTypeGroup.unknown);
    private final SQLType sqlType;
    private final Class<?> defaultMappedClass;
    private final JavaSqlTypeGroup javaSqlTypeGroup;

    public JavaSqlType(SQLType sqlType, Class<?> defaultMappedClass, JavaSqlTypeGroup javaSqlTypeGroup) {
        this.sqlType = Objects.requireNonNull(sqlType, "No SQLType provided");
        this.defaultMappedClass = Objects.requireNonNull(defaultMappedClass, "Np default mapped class provided");
        this.javaSqlTypeGroup = Objects.requireNonNull(javaSqlTypeGroup, "No SQLType group provided");
    }

    private JavaSqlType(final int typeNumber, final String typeName, Class<?> defaultMappedClass, JavaSqlTypeGroup sqlTypeGroup) {
        this(new SQLType(){

            @Override
            public String getName() {
                return typeName;
            }

            @Override
            public String getVendor() {
                return "SchemaCrawler";
            }

            @Override
            public Integer getVendorTypeNumber() {
                return typeNumber;
            }
        }, defaultMappedClass, sqlTypeGroup);
    }

    @Override
    public int compareTo(JavaSqlType otherSqlDataType) {
        return this.sqlType.getName().compareTo(otherSqlDataType.sqlType.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaSqlType other = (JavaSqlType)obj;
        return !(this.sqlType == null ? other.sqlType != null : !this.sqlType.getVendorTypeNumber().equals(other.sqlType.getVendorTypeNumber()));
    }

    public Class<?> getDefaultMappedClass() {
        return this.defaultMappedClass;
    }

    public JavaSqlTypeGroup getJavaSqlTypeGroup() {
        return this.javaSqlTypeGroup;
    }

    @Override
    public String getName() {
        return this.sqlType.getName();
    }

    @Override
    public String getVendor() {
        return this.sqlType.getVendor();
    }

    @Override
    public Integer getVendorTypeNumber() {
        Integer vendorTypeNumber = this.sqlType.getVendorTypeNumber();
        if (vendorTypeNumber != null) {
            return vendorTypeNumber;
        }
        return Integer.MAX_VALUE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sqlType == null ? 0 : this.sqlType.getVendorTypeNumber());
        return result;
    }

    public String toString() {
        return String.format("%s\t%d\t%s", new Object[]{this.sqlType.getName(), this.sqlType.getVendorTypeNumber(), this.javaSqlTypeGroup});
    }
}

