/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevel;

public final class SchemaInfoLevelBuilder
implements OptionsBuilder<SchemaInfoLevelBuilder, SchemaInfoLevel> {
    private String tag;
    private boolean retrieveTables;
    private boolean retrieveRoutines;
    private boolean retrieveColumnDataTypes;
    private boolean retrieveDatabaseInfo;
    private boolean retrieveAdditionalDatabaseInfo;
    private boolean retrieveServerInfo;
    private boolean retrieveAdditionalJdbcDriverInfo;
    private boolean retrieveUserDefinedColumnDataTypes;
    private boolean retrieveRoutineColumns;
    private boolean retrieveRoutineInformation;
    private boolean retrieveTableConstraintInformation;
    private boolean retrieveTableConstraintDefinitions;
    private boolean retrieveViewInformation;
    private boolean retrieveIndexInformation;
    private boolean retrieveIndexColumnInformation;
    private boolean retrievePrimaryKeyDefinitions;
    private boolean retrieveForeignKeys;
    private boolean retrieveForeignKeyDefinitions;
    private boolean retrieveIndexes;
    private boolean retrieveTablePrivileges;
    private boolean retrieveTableColumnPrivileges;
    private boolean retrieveTriggerInformation;
    private boolean retrieveSynonymInformation;
    private boolean retrieveSequenceInformation;
    private boolean retrieveTableColumns;
    private boolean retrieveAdditionalTableAttributes;
    private boolean retrieveAdditionalColumnAttributes;
    private boolean retrieveTableDefinitionsInformation;

    public static SchemaInfoLevelBuilder detailed() {
        SchemaInfoLevelBuilder detailed = SchemaInfoLevelBuilder.standard();
        detailed.setRetrieveUserDefinedColumnDataTypes(true);
        detailed.setRetrieveTriggerInformation(true);
        detailed.setRetrieveTableConstraintInformation(true);
        detailed.setRetrieveTableConstraintDefinitions(true);
        detailed.setRetrieveViewInformation(true);
        detailed.setRetrieveRoutineInformation(true);
        detailed.setTag("detailed");
        return detailed;
    }

    public static SchemaInfoLevelBuilder maximum() {
        SchemaInfoLevelBuilder maximum = SchemaInfoLevelBuilder.detailed();
        maximum.setRetrieveAdditionalDatabaseInfo(true);
        maximum.setRetrieveServerInfo(true);
        maximum.setRetrieveAdditionalJdbcDriverInfo(true);
        maximum.setRetrieveTablePrivileges(true);
        maximum.setRetrieveTableColumnPrivileges(true);
        maximum.setRetrieveTableDefinitionsInformation(true);
        maximum.setRetrieveForeignKeyDefinitions(true);
        maximum.setRetrievePrimaryKeyDefinitions(true);
        maximum.setRetrieveAdditionalTableAttributes(true);
        maximum.setRetrieveAdditionalColumnAttributes(true);
        maximum.setRetrieveIndexInformation(true);
        maximum.setRetrieveIndexColumnInformation(true);
        maximum.setRetrieveSequenceInformation(true);
        maximum.setRetrieveSynonymInformation(true);
        maximum.setTag("maximum");
        return maximum;
    }

    public static SchemaInfoLevelBuilder minimum() {
        SchemaInfoLevelBuilder minimum = new SchemaInfoLevelBuilder();
        minimum.setRetrieveDatabaseInfo(true);
        minimum.setRetrieveTables(true);
        minimum.setRetrieveRoutines(true);
        minimum.setTag("minimum");
        return minimum;
    }

    public static SchemaInfoLevelBuilder standard() {
        SchemaInfoLevelBuilder standard = SchemaInfoLevelBuilder.minimum();
        standard.setRetrieveColumnDataTypes(true);
        standard.setRetrieveTableColumns(true);
        standard.setRetrieveForeignKeys(true);
        standard.setRetrieveIndexes(true);
        standard.setRetrieveRoutineColumns(true);
        standard.setTag("standard");
        return standard;
    }

    private SchemaInfoLevelBuilder() {
    }

    public SchemaInfoLevelBuilder fromConfig(Config config) {
        throw new UnsupportedOperationException();
    }

    public SchemaInfoLevelBuilder fromOptions(SchemaInfoLevel schemaInfoLevel) {
        if (schemaInfoLevel == null) {
            return this;
        }
        this.tag = schemaInfoLevel.getTag();
        this.retrieveTables = schemaInfoLevel.isRetrieveTables();
        this.retrieveRoutines = schemaInfoLevel.isRetrieveRoutines();
        this.retrieveColumnDataTypes = schemaInfoLevel.isRetrieveColumnDataTypes();
        this.retrieveDatabaseInfo = schemaInfoLevel.isRetrieveDatabaseInfo();
        this.retrieveAdditionalDatabaseInfo = schemaInfoLevel.isRetrieveAdditionalDatabaseInfo();
        this.retrieveServerInfo = schemaInfoLevel.isRetrieveServerInfo();
        this.retrieveAdditionalJdbcDriverInfo = schemaInfoLevel.isRetrieveAdditionalJdbcDriverInfo();
        this.retrieveUserDefinedColumnDataTypes = schemaInfoLevel.isRetrieveUserDefinedColumnDataTypes();
        this.retrieveRoutineColumns = schemaInfoLevel.isRetrieveRoutineColumns();
        this.retrieveRoutineInformation = schemaInfoLevel.isRetrieveRoutineInformation();
        this.retrieveTableConstraintInformation = schemaInfoLevel.isRetrieveTableConstraintInformation();
        this.retrieveTableConstraintDefinitions = schemaInfoLevel.isRetrieveTableConstraintDefinitions();
        this.retrieveViewInformation = schemaInfoLevel.isRetrieveViewInformation();
        this.retrieveIndexInformation = schemaInfoLevel.isRetrieveIndexInformation();
        this.retrieveIndexColumnInformation = schemaInfoLevel.isRetrieveIndexColumnInformation();
        this.retrievePrimaryKeyDefinitions = schemaInfoLevel.isRetrievePrimaryKeyDefinitions();
        this.retrieveForeignKeys = schemaInfoLevel.isRetrieveForeignKeys();
        this.retrieveForeignKeyDefinitions = schemaInfoLevel.isRetrieveForeignKeyDefinitions();
        this.retrieveIndexes = schemaInfoLevel.isRetrieveIndexes();
        this.retrieveTablePrivileges = schemaInfoLevel.isRetrieveTablePrivileges();
        this.retrieveTableColumnPrivileges = schemaInfoLevel.isRetrieveTableColumnPrivileges();
        this.retrieveTriggerInformation = schemaInfoLevel.isRetrieveTriggerInformation();
        this.retrieveSynonymInformation = schemaInfoLevel.isRetrieveSynonymInformation();
        this.retrieveSequenceInformation = schemaInfoLevel.isRetrieveSequenceInformation();
        this.retrieveTableColumns = schemaInfoLevel.isRetrieveTableColumns();
        this.retrieveAdditionalTableAttributes = schemaInfoLevel.isRetrieveAdditionalTableAttributes();
        this.retrieveAdditionalColumnAttributes = schemaInfoLevel.isRetrieveAdditionalColumnAttributes();
        this.retrieveTableDefinitionsInformation = schemaInfoLevel.isRetrieveTableDefinitionsInformation();
        return this;
    }

    public String getTag() {
        return this.tag;
    }

    public SchemaInfoLevelBuilder setRetrieveAdditionalColumnAttributes(boolean retrieveAdditionalColumnAttributes) {
        this.retrieveAdditionalColumnAttributes = retrieveAdditionalColumnAttributes;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveAdditionalDatabaseInfo(boolean retrieveAdditionalDatabaseInfo) {
        this.retrieveAdditionalDatabaseInfo = retrieveAdditionalDatabaseInfo;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveAdditionalJdbcDriverInfo(boolean retrieveAdditionalJdbcDriverInfo) {
        this.retrieveAdditionalJdbcDriverInfo = retrieveAdditionalJdbcDriverInfo;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveAdditionalTableAttributes(boolean retrieveAdditionalTableAttributes) {
        this.retrieveAdditionalTableAttributes = retrieveAdditionalTableAttributes;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveColumnDataTypes(boolean retrieveColumnDataTypes) {
        this.retrieveColumnDataTypes = retrieveColumnDataTypes;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveDatabaseInfo(boolean retrieveDatabaseInfo) {
        this.retrieveDatabaseInfo = retrieveDatabaseInfo;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveForeignKeyDefinitions(boolean retrieveForeignKeyDefinitions) {
        this.retrieveForeignKeyDefinitions = retrieveForeignKeyDefinitions;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveForeignKeys(boolean retrieveForeignKeys) {
        this.retrieveForeignKeys = retrieveForeignKeys;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveIndexColumnInformation(boolean retrieveIndexColumnInformation) {
        this.retrieveIndexColumnInformation = retrieveIndexColumnInformation;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveIndexes(boolean retrieveIndexes) {
        this.retrieveIndexes = retrieveIndexes;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveIndexInformation(boolean retrieveIndexInformation) {
        this.retrieveIndexInformation = retrieveIndexInformation;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrievePrimaryKeyDefinitions(boolean retrievePrimaryKeyDefinitions) {
        this.retrievePrimaryKeyDefinitions = retrievePrimaryKeyDefinitions;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveRoutineColumns(boolean retrieveRoutineColumns) {
        this.retrieveRoutineColumns = retrieveRoutineColumns;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveRoutineInformation(boolean retrieveRoutineInformation) {
        this.retrieveRoutineInformation = retrieveRoutineInformation;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveRoutines(boolean retrieveRoutines) {
        this.retrieveRoutines = retrieveRoutines;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveSequenceInformation(boolean retrieveSequenceInformation) {
        this.retrieveSequenceInformation = retrieveSequenceInformation;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveServerInfo(boolean retrieveServerInfo) {
        this.retrieveServerInfo = retrieveServerInfo;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveSynonymInformation(boolean retrieveSynonymInformation) {
        this.retrieveSynonymInformation = retrieveSynonymInformation;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTableColumnPrivileges(boolean retrieveTableColumnPrivileges) {
        this.retrieveTableColumnPrivileges = retrieveTableColumnPrivileges;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTableColumns(boolean retrieveTableColumns) {
        this.retrieveTableColumns = retrieveTableColumns;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTableConstraintDefinitions(boolean retrieveTableConstraintDefinitions) {
        this.retrieveTableConstraintDefinitions = retrieveTableConstraintDefinitions;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTableConstraintInformation(boolean retrieveTableConstraintInformation) {
        this.retrieveTableConstraintInformation = retrieveTableConstraintInformation;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTableDefinitionsInformation(boolean retrieveTableDefinitionsInformation) {
        this.retrieveTableDefinitionsInformation = retrieveTableDefinitionsInformation;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTablePrivileges(boolean retrieveTablePrivileges) {
        this.retrieveTablePrivileges = retrieveTablePrivileges;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTables(boolean retrieveTables) {
        this.retrieveTables = retrieveTables;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveTriggerInformation(boolean retrieveTriggerInformation) {
        this.retrieveTriggerInformation = retrieveTriggerInformation;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveUserDefinedColumnDataTypes(boolean retrieveUserDefinedColumnDataTypes) {
        this.retrieveUserDefinedColumnDataTypes = retrieveUserDefinedColumnDataTypes;
        return this;
    }

    public SchemaInfoLevelBuilder setRetrieveViewInformation(boolean retrieveViewInformation) {
        this.retrieveViewInformation = retrieveViewInformation;
        return this;
    }

    public SchemaInfoLevelBuilder setTag(String tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public Config toConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaInfoLevel toOptions() {
        return new SchemaInfoLevel(this.tag, this.retrieveTables, this.retrieveRoutines, this.retrieveColumnDataTypes, this.retrieveDatabaseInfo, this.retrieveAdditionalDatabaseInfo, this.retrieveServerInfo, this.retrieveAdditionalJdbcDriverInfo, this.retrieveUserDefinedColumnDataTypes, this.retrieveRoutineColumns, this.retrieveRoutineInformation, this.retrieveTableConstraintInformation, this.retrieveTableConstraintDefinitions, this.retrieveViewInformation, this.retrieveIndexInformation, this.retrieveIndexColumnInformation, this.retrievePrimaryKeyDefinitions, this.retrieveForeignKeys, this.retrieveForeignKeyDefinitions, this.retrieveIndexes, this.retrieveTablePrivileges, this.retrieveTableColumnPrivileges, this.retrieveTriggerInformation, this.retrieveSynonymInformation, this.retrieveSequenceInformation, this.retrieveTableColumns, this.retrieveAdditionalTableAttributes, this.retrieveAdditionalColumnAttributes, this.retrieveTableDefinitionsInformation);
    }

    public String toString() {
        return this.tag == null ? "" : this.tag;
    }
}

