/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.utility.Identifiers;
import schemacrawler.utility.TypeMap;
import sf.util.Utility;

public final class SchemaRetrievalOptions
implements Options {
    private final DatabaseServerType dbServerType;
    private final boolean supportsSchemas;
    private final boolean supportsCatalogs;
    private final MetadataRetrievalStrategy tableRetrievalStrategy;
    private final MetadataRetrievalStrategy tableColumnRetrievalStrategy;
    private final MetadataRetrievalStrategy pkRetrievalStrategy;
    private final MetadataRetrievalStrategy indexRetrievalStrategy;
    private final MetadataRetrievalStrategy fkRetrievalStrategy;
    private final MetadataRetrievalStrategy procedureRetrievalStrategy;
    private final MetadataRetrievalStrategy procedureColumnRetrievalStrategy;
    private final MetadataRetrievalStrategy functionRetrievalStrategy;
    private final MetadataRetrievalStrategy functionColumnRetrievalStrategy;
    private final String identifierQuoteString;
    private final InformationSchemaViews informationSchemaViews;
    private final TypeMap typeMap;
    private final Identifiers identifiers;

    protected SchemaRetrievalOptions(SchemaRetrievalOptionsBuilder builder) {
        SchemaRetrievalOptionsBuilder bldr = builder == null ? SchemaRetrievalOptionsBuilder.builder() : builder;
        this.dbServerType = bldr.getDatabaseServerType();
        this.supportsSchemas = bldr.isSupportsSchemas();
        this.supportsCatalogs = bldr.isSupportsCatalogs();
        this.tableRetrievalStrategy = bldr.getTableRetrievalStrategy();
        this.tableColumnRetrievalStrategy = bldr.getTableColumnRetrievalStrategy();
        this.pkRetrievalStrategy = bldr.getPrimaryKeyRetrievalStrategy();
        this.indexRetrievalStrategy = bldr.getIndexRetrievalStrategy();
        this.fkRetrievalStrategy = bldr.getForeignKeyRetrievalStrategy();
        this.procedureRetrievalStrategy = bldr.getProcedureRetrievalStrategy();
        this.procedureColumnRetrievalStrategy = bldr.getProcedureColumnRetrievalStrategy();
        this.functionRetrievalStrategy = bldr.getFunctionRetrievalStrategy();
        this.functionColumnRetrievalStrategy = bldr.getFunctionColumnRetrievalStrategy();
        this.identifierQuoteString = bldr.getIdentifierQuoteString();
        this.informationSchemaViews = bldr.getInformationSchemaViews();
        this.identifiers = bldr.getIdentifiers();
        this.typeMap = bldr.getTypeMap();
    }

    public DatabaseServerType getDatabaseServerType() {
        return this.dbServerType;
    }

    public MetadataRetrievalStrategy getForeignKeyRetrievalStrategy() {
        return this.fkRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getFunctionColumnRetrievalStrategy() {
        return this.functionColumnRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getFunctionRetrievalStrategy() {
        return this.functionRetrievalStrategy;
    }

    public String getIdentifierQuoteString() {
        if (!this.hasOverrideForIdentifierQuoteString()) {
            return "";
        }
        return this.identifierQuoteString;
    }

    public Identifiers getIdentifiers() {
        return this.identifiers;
    }

    public MetadataRetrievalStrategy getIndexRetrievalStrategy() {
        return this.indexRetrievalStrategy;
    }

    public InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViews;
    }

    public MetadataRetrievalStrategy getPrimaryKeyRetrievalStrategy() {
        return this.pkRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getProcedureColumnRetrievalStrategy() {
        return this.procedureColumnRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getProcedureRetrievalStrategy() {
        return this.procedureRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getTableColumnRetrievalStrategy() {
        return this.tableColumnRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getTableRetrievalStrategy() {
        return this.tableRetrievalStrategy;
    }

    public TypeMap getTypeMap() {
        return this.typeMap;
    }

    public boolean hasOverrideForIdentifierQuoteString() {
        return !Utility.isBlank(this.identifierQuoteString);
    }

    public boolean hasOverrideForTypeMap() {
        return this.typeMap != null;
    }

    public boolean isSupportsCatalogs() {
        return this.supportsCatalogs;
    }

    public boolean isSupportsSchemas() {
        return this.supportsSchemas;
    }
}

