/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.iosource;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import schemacrawler.tools.iosource.OutputResource;
import schemacrawler.tools.iosource.OutputWriter;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class CompressedFileOutputResource
implements OutputResource {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(CompressedFileOutputResource.class.getName());
    private final Path outputFile;
    private final String internalPath;

    public CompressedFileOutputResource(Path outputFile, String internalPath) throws IOException {
        Objects.requireNonNull(outputFile, "No output file provided");
        this.outputFile = outputFile.normalize().toAbsolutePath();
        if (!IOUtility.isFileWritable(this.outputFile)) {
            throw new IOException("Cannot write output file, " + this.outputFile);
        }
        this.internalPath = Objects.requireNonNull(internalPath, "No internal file path provided");
    }

    public Path getOutputFile() {
        return this.outputFile;
    }

    @Override
    public Writer openNewOutputWriter(Charset charset, boolean appendOutput) throws IOException {
        if (appendOutput) {
            throw new IOException("Cannot append to compressed file");
        }
        OpenOption[] openOptions = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        OutputStream fileStream = Files.newOutputStream(this.outputFile, openOptions);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileStream);
        zipOutputStream.putNextEntry(new ZipEntry(this.internalPath));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipOutputStream, charset);
        LOGGER.log(Level.INFO, new StringFormat("Opened output writer to compressed file <%s>", this.outputFile));
        return new OutputWriter(this.getDescription(), writer, true);
    }

    public String toString() {
        return this.outputFile.toString();
    }
}

