/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class DatabaseUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(DatabaseUtility.class.getName());

    public static Connection checkConnection(Connection connection) throws SchemaCrawlerSQLException {
        try {
            Objects.requireNonNull(connection, "No connection provided");
            if (connection.isClosed()) {
                throw new SQLException("Connection is closed");
            }
        }
        catch (NullPointerException | SQLException e) {
            throw new SchemaCrawlerSQLException("Bad database connection", e);
        }
        return connection;
    }

    public static ResultSet checkResultSet(ResultSet resultSet) throws SchemaCrawlerSQLException {
        try {
            Objects.requireNonNull(resultSet, "No result-set provided");
            if (resultSet.isClosed()) {
                throw new SQLException("Result-set is closed");
            }
        }
        catch (NullPointerException | SQLException e) {
            throw new SchemaCrawlerSQLException("Bad result-set", e);
        }
        return resultSet;
    }

    public static Statement createStatement(Connection connection) throws SQLException {
        DatabaseUtility.checkConnection(connection);
        return connection.createStatement();
    }

    public static void executeScriptFromResource(Connection connection, String scriptResource) {
        try (Statement statement = DatabaseUtility.createStatement(connection);){
            String sqlScript = IOUtility.readResourceFully(scriptResource);
            if (!Utility.isBlank(sqlScript)) {
                for (String sql : sqlScript.split(";")) {
                    ResultSet resultSet;
                    if (Utility.isBlank(sql) || (resultSet = DatabaseUtility.executeSql(statement, sql, false)) == null) continue;
                    LOGGER.log(Level.WARNING, new StringFormat("Ignoring results from query <%s>", sql));
                    resultSet.close();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), (Throwable)e);
        }
    }

    public static ResultSet executeSql(Statement statement, String sql) throws SQLException {
        return DatabaseUtility.executeSql(statement, sql, false);
    }

    public static ResultSet executeSql(Statement statement, String sql, boolean throwSQLException) throws SQLException {
        ResultSet results = null;
        if (statement == null) {
            return results;
        }
        if (Utility.isBlank(sql)) {
            LOGGER.log(Level.FINE, "No SQL provided", (Throwable)new RuntimeException("No SQL provided"));
            return results;
        }
        try {
            statement.clearWarnings();
            boolean hasResults = statement.execute(sql);
            if (hasResults) {
                results = statement.getResultSet();
            } else {
                int updateCount = statement.getUpdateCount();
                LOGGER.log(Level.FINE, new StringFormat("No results. Update count of %d for query: %s", updateCount, sql));
            }
            DatabaseUtility.logSQLWarnings(statement);
            return results;
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, new StringFormat("Error executing SQL <%s>", sql), (Throwable)e);
            if (throwSQLException) {
                throw e;
            }
            return null;
        }
    }

    public static long executeSqlForLong(Connection connection, String sql) throws SchemaCrawlerException {
        Object longValue = DatabaseUtility.executeSqlForScalar(connection, sql);
        if (longValue == null || !(longValue instanceof Number)) {
            throw new SchemaCrawlerException("Cannot get an integer value result from SQL");
        }
        return ((Number)longValue).longValue();
    }

    /*
     * Exception decompiling
     */
    public static Object executeSqlForScalar(Connection connection, String sql) throws SchemaCrawlerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getDatabaseVersion(Connection connection) throws SQLException {
        DatabaseUtility.checkConnection(connection);
        DatabaseMetaData dbMetaData = connection.getMetaData();
        String dbProductName = dbMetaData.getDatabaseProductName();
        String dbProductVersion = dbMetaData.getDatabaseProductVersion();
        return dbProductName + " " + dbProductVersion;
    }

    public static void logSQLWarnings(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        if (!LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        try {
            DatabaseUtility.logSQLWarnings(resultSet.getWarnings());
            resultSet.clearWarnings();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not log SQL warnings for result set");
        }
    }

    public static void logSQLWarnings(Statement statement) {
        if (statement == null) {
            return;
        }
        if (!LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        try {
            DatabaseUtility.logSQLWarnings(statement.getWarnings());
            statement.clearWarnings();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not log SQL warnings for statement");
        }
    }

    public static List<String> readResultsVector(ResultSet results) throws SQLException {
        ArrayList<String> values = new ArrayList<String>();
        if (results == null) {
            return values;
        }
        try {
            while (results.next()) {
                String value = results.getString(1);
                if (results.wasNull() || Utility.isBlank(value)) continue;
                values.add(value.trim());
            }
        }
        finally {
            results.close();
        }
        return values;
    }

    private static void logSQLWarnings(SQLWarning sqlWarning) {
        Level level = Level.FINER;
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        for (SQLWarning currentSqlWarning = sqlWarning; currentSqlWarning != null; currentSqlWarning = currentSqlWarning.getNextWarning()) {
            String message = String.format("%s%nError code: %d, SQL state: %s", currentSqlWarning.getMessage(), currentSqlWarning.getErrorCode(), currentSqlWarning.getSQLState());
            LOGGER.log(level, message, (Throwable)currentSqlWarning);
        }
    }

    private DatabaseUtility() {
    }
}

