/*
 * Decompiled with CFR 0.152.
 */
package us.springett.nistdatamirror;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.GZIPInputStream;

public class NistDataMirror {
    private static final String CVE_XML_12_MODIFIED_URL = "https://nvd.nist.gov/feeds/xml/cve/1.2/nvdcve-modified.xml.gz";
    private static final String CVE_XML_20_MODIFIED_URL = "https://nvd.nist.gov/feeds/xml/cve/2.0/nvdcve-2.0-modified.xml.gz";
    private static final String CVE_XML_12_BASE_URL = "https://nvd.nist.gov/feeds/xml/cve/1.2/nvdcve-%d.xml.gz";
    private static final String CVE_XML_20_BASE_URL = "https://nvd.nist.gov/feeds/xml/cve/2.0/nvdcve-2.0-%d.xml.gz";
    private static final String CVE_JSON_10_MODIFIED_URL = "https://nvd.nist.gov/feeds/json/cve/1.0/nvdcve-1.0-modified.json.gz";
    private static final String CVE_JSON_10_BASE_URL = "https://nvd.nist.gov/feeds/json/cve/1.0/nvdcve-1.0-%d.json.gz";
    private static final int START_YEAR = 2002;
    private static final int END_YEAR = Calendar.getInstance().get(1);
    private File outputDir;
    private boolean downloadFailed = false;
    private boolean json = true;
    private boolean xml = true;

    public static void main(String[] args) {
        if (args.length == 0 || args.length > 2) {
            System.out.println("Usage: java NistDataMirror outputDir [xml|json]");
            return;
        }
        String type = null;
        if (args.length == 2) {
            type = args[1];
        }
        NistDataMirror nvd = new NistDataMirror(args[0], type);
        nvd.mirror();
        if (nvd.downloadFailed) {
            System.exit(1);
        }
    }

    public NistDataMirror(String outputDirPath, String type) {
        this.outputDir = new File(outputDirPath);
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        if (type != null) {
            if (type.equals("xml")) {
                this.json = false;
            } else if (type.equals("json")) {
                this.xml = false;
            } else {
                throw new IllegalArgumentException(String.format("Invalid type parameter '%s'. Usage: java NistDataMirror outputDir [xml|json]", type));
            }
        }
    }

    public void mirror() {
        Date currentDate = new Date();
        System.out.println("Downloading files at " + currentDate);
        if (this.xml) {
            this.doDownload(CVE_XML_12_MODIFIED_URL);
            this.doDownload(CVE_XML_20_MODIFIED_URL);
        }
        if (this.json) {
            this.doDownload(CVE_JSON_10_MODIFIED_URL);
        }
        for (int i = 2002; i <= END_YEAR; ++i) {
            if (this.xml) {
                String cve12BaseUrl = CVE_XML_12_BASE_URL.replace("%d", String.valueOf(i));
                String cve20BaseUrl = CVE_XML_20_BASE_URL.replace("%d", String.valueOf(i));
                this.doDownload(cve12BaseUrl);
                this.doDownload(cve20BaseUrl);
            }
            if (!this.json) continue;
            String cveJsonBaseUrl = CVE_JSON_10_BASE_URL.replace("%d", String.valueOf(i));
            this.doDownload(cveJsonBaseUrl);
        }
    }

    private long checkHead(String cveUrl) {
        try {
            URL url = new URL(cveUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.connect();
            connection.getInputStream();
            return connection.getContentLengthLong();
        }
        catch (IOException e) {
            System.out.println("Failed to determine content length");
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDownload(String cveUrl) {
        boolean success;
        File file;
        block10: {
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            file = null;
            success = false;
            try {
                int i;
                URL url = new URL(cveUrl);
                String filename = url.getFile();
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                file = new File(this.outputDir, filename).getAbsoluteFile();
                if (file.exists()) {
                    long fileSize = this.checkHead(cveUrl);
                    if (file.length() == fileSize) {
                        System.out.println("Using cached version of " + filename);
                        this.close(bis);
                        this.close(bos);
                        return;
                    }
                }
                URLConnection connection = url.openConnection();
                System.out.println("Downloading " + url.toExternalForm());
                bis = new BufferedInputStream(connection.getInputStream());
                file = new File(this.outputDir, filename);
                bos = new BufferedOutputStream(new FileOutputStream(file));
                while ((i = bis.read()) != -1) {
                    bos.write(i);
                }
                success = true;
                this.close(bis);
            }
            catch (IOException e) {
                System.out.println("Download failed : " + e.getLocalizedMessage());
                this.downloadFailed = true;
                break block10;
            }
            finally {
                this.close(bis);
                this.close(bos);
            }
            this.close(bos);
        }
        if (file != null && success) {
            this.uncompress(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uncompress(File file) {
        byte[] buffer = new byte[1024];
        GZIPInputStream gzis = null;
        FileOutputStream out = null;
        try {
            int len;
            System.out.println("Uncompressing " + file.getName());
            gzis = new GZIPInputStream(new FileInputStream(file));
            out = new FileOutputStream(new File(file.getAbsolutePath().replaceAll(".gz", "")));
            while ((len = gzis.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            this.close(gzis);
            this.close(out);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            this.close(gzis);
            this.close(out);
        }
    }

    private void close(Closeable object) {
        if (object != null) {
            try {
                object.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

