/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.classifiers;

import ws.palladian.classification.text.DictionaryModel;
import ws.palladian.classification.text.FeatureSetting;
import ws.palladian.classification.text.FeatureSettingBuilder;
import ws.palladian.classification.text.PalladianTextClassifier;
import ws.palladian.core.CategoryEntries;
import ws.palladian.core.Classifier;
import ws.palladian.core.FeatureVector;
import ws.palladian.core.Instance;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.core.Learner;
import ws.palladian.core.dataset.Dataset;
import ws.palladian.core.value.NumericValue;
import ws.palladian.helper.collection.CollectionHelper;
import ws.palladian.helper.collection.Vector;

public class PalladianDictionaryClassifier
implements Learner<DictionaryModel>,
Classifier<DictionaryModel> {
    private static final FeatureSetting FEATURE_SETTING = FeatureSettingBuilder.words().create();
    private final PalladianTextClassifier textClassifier;
    private final PalladianTextClassifier.Scorer scorer;

    public PalladianDictionaryClassifier() {
        this((PalladianTextClassifier.Scorer)new PalladianTextClassifier.DefaultScorer());
    }

    public PalladianDictionaryClassifier(PalladianTextClassifier.Scorer scorer) {
        this.textClassifier = new PalladianTextClassifier(FEATURE_SETTING, scorer);
        this.scorer = scorer;
    }

    public CategoryEntries classify(FeatureVector featureVector, DictionaryModel model) {
        String text = PalladianDictionaryClassifier.convertToTextFeatureVector(featureVector);
        return this.textClassifier.classify(text, model);
    }

    public DictionaryModel train(Iterable<? extends Instance> instances) {
        return (DictionaryModel)this.textClassifier.train(this.convertToTextInstances(instances));
    }

    public DictionaryModel train(Dataset dataset) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public DictionaryModel train(Dataset training, Dataset validation) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private Iterable<Instance> convertToTextInstances(Iterable<? extends Instance> instances) {
        return CollectionHelper.convert(instances, input -> {
            String text = PalladianDictionaryClassifier.convertToTextFeatureVector(input.getVector());
            return new InstanceBuilder().setText(text).create(input.getCategory());
        });
    }

    private static String convertToTextFeatureVector(FeatureVector vector) {
        StringBuilder dummyText = new StringBuilder();
        for (Vector.VectorEntry entry : vector) {
            if (!(entry.value() instanceof NumericValue)) continue;
            NumericValue count = (NumericValue)entry.value();
            for (long i = 0L; i < count.getLong(); ++i) {
                dummyText.append((String)entry.key());
                dummyText.append(" ");
            }
        }
        return dummyText.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.scorer + ")";
    }
}

