/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.classifiers.cloudservices;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.rekognition.AmazonRekognitionClientBuilder;
import com.amazonaws.services.rekognition.model.AmazonRekognitionException;
import com.amazonaws.services.rekognition.model.DetectLabelsRequest;
import com.amazonaws.services.rekognition.model.DetectLabelsResult;
import com.amazonaws.services.rekognition.model.Image;
import com.amazonaws.services.rekognition.model.Label;
import com.amazonaws.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import ws.palladian.classifiers.cloudservices.ImageClassifier;
import ws.palladian.helper.collection.CollectionHelper;

public class AmazonRekognition
implements ImageClassifier {
    private AWSCredentials credentials = null;
    private static final String apiKeyKey = "api.amazon.cloud.key";
    private static final String apiSecretKey = "api.amazon.cloud.secret";
    private int maxLabels = 10;

    public AmazonRekognition(Configuration configuration) {
        this(configuration.getString(apiKeyKey), configuration.getString(apiSecretKey));
    }

    public AmazonRekognition(String apiKey, String apiSecret) {
        try {
            this.credentials = new BasicAWSCredentials(apiKey, apiSecret);
        }
        catch (Exception e) {
            throw new AmazonClientException("Incorrect apiKey and/or apiSecret.", (Throwable)e);
        }
    }

    @Override
    public void setMaxLabels(int maxLabels) {
        this.maxLabels = maxLabels;
    }

    @Override
    public List<String> classify(File image) throws Exception {
        return this.classify(image, this.maxLabels);
    }

    public List<String> classify(File image, int maxLabels) throws IOException {
        ByteBuffer imageBytes;
        ArrayList<String> labels = new ArrayList<String>();
        if (maxLabels < 1) {
            maxLabels = 1;
        }
        com.amazonaws.services.rekognition.AmazonRekognition rekognitionClient = (com.amazonaws.services.rekognition.AmazonRekognition)((AmazonRekognitionClientBuilder)((AmazonRekognitionClientBuilder)AmazonRekognitionClientBuilder.standard().withRegion(Regions.DEFAULT_REGION)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(this.credentials))).build();
        try (FileInputStream inputStream = new FileInputStream(image);){
            imageBytes = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)inputStream));
        }
        Image amazonImage = new Image();
        amazonImage.setBytes(imageBytes);
        DetectLabelsRequest request = new DetectLabelsRequest().withImage(amazonImage).withMaxLabels(Integer.valueOf(maxLabels)).withMinConfidence(Float.valueOf(0.0f));
        try {
            DetectLabelsResult result = rekognitionClient.detectLabels(request);
            List apiLabels = result.getLabels();
            for (Label label : apiLabels) {
                labels.add(label.getName());
            }
        }
        catch (AmazonRekognitionException e) {
            e.printStackTrace();
        }
        return labels;
    }

    public static void main(String ... args) throws Exception {
        AmazonRekognition amazonRekognition = new AmazonRekognition("appId", "appSecret");
        List<String> labels = amazonRekognition.classify(new File("dog.jpg"), 10);
        CollectionHelper.print(labels);
    }
}

