/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.classifiers.cloudservices;

import clarifai2.api.ClarifaiBuilder;
import clarifai2.api.ClarifaiClient;
import clarifai2.api.ClarifaiResponse;
import clarifai2.dto.input.ClarifaiInput;
import clarifai2.dto.model.ConceptModel;
import clarifai2.dto.model.output.ClarifaiOutput;
import clarifai2.dto.prediction.Concept;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import ws.palladian.classifiers.cloudservices.ImageClassifier;
import ws.palladian.core.Category;
import ws.palladian.core.CategoryEntries;
import ws.palladian.core.ImmutableCategory;
import ws.palladian.core.ImmutableCategoryEntries;
import ws.palladian.helper.collection.CollectionHelper;

public class Clarifai
implements ImageClassifier {
    private final ClarifaiClient client;
    private static final String apiKeyIdentifier = "api.clarifai.key";
    private int maxLabels = 10;

    public Clarifai(Configuration configuration) {
        this(configuration.getString(apiKeyIdentifier));
    }

    public Clarifai(String apiKey) {
        this.client = new ClarifaiBuilder(apiKey).buildSync();
    }

    public ClarifaiClient getClient() {
        return this.client;
    }

    @Override
    public void setMaxLabels(int maxLabels) {
        this.maxLabels = maxLabels;
    }

    @Override
    public List<String> classify(File image) {
        return this.classify(image, this.client.getDefaultModels().generalModel());
    }

    public List<String> classify(File image, ConceptModel model) {
        CategoryEntries centries = this.classifyWithProbability(image, model);
        ArrayList<String> names = new ArrayList<String>();
        for (Category centry : centries) {
            names.add(centry.getName());
        }
        return names;
    }

    public CategoryEntries classifyWithProbability(File image, ConceptModel model) {
        LinkedHashMap<String, ImmutableCategory> entryMap = new LinkedHashMap<String, ImmutableCategory>();
        ImmutableCategory mostLikely = new ImmutableCategory("unknown", 0.0);
        ClarifaiResponse listClarifaiResponse = model.predict().withInputs(new ClarifaiInput[]{ClarifaiInput.forImage((File)image)}).executeSync();
        block0: for (ClarifaiOutput conceptClarifaiOutput : (List)listClarifaiResponse.get()) {
            for (Concept concept : conceptClarifaiOutput.data()) {
                if (concept == null) continue;
                ImmutableCategory category = new ImmutableCategory(concept.name(), (double)concept.value());
                entryMap.put(concept.name(), category);
                if ((double)concept.value() > mostLikely.getProbability()) {
                    mostLikely = category;
                }
                if (entryMap.keySet().size() < this.maxLabels) continue;
                continue block0;
            }
        }
        return new ImmutableCategoryEntries(entryMap, (Category)mostLikely);
    }

    public static void main(String ... args) throws Exception {
        Clarifai clarifaiClient = new Clarifai("apiKey");
        CategoryEntries entries = clarifaiClient.classifyWithProbability(new File("food.jpg"), clarifaiClient.getClient().getDefaultModels().foodModel());
        CollectionHelper.print((Iterable)entries);
    }
}

