/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.classifiers.cloudservices;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import ws.palladian.classifiers.cloudservices.ImageClassifier;
import ws.palladian.helper.collection.CollectionHelper;
import ws.palladian.retrieval.parser.json.JsonArray;
import ws.palladian.retrieval.parser.json.JsonException;
import ws.palladian.retrieval.parser.json.JsonObject;

public class GoogleCloudVision
implements ImageClassifier {
    private final String apiKey;
    private int maxLabels = 10;

    public GoogleCloudVision(Configuration configuration) {
        this(configuration.getString("api.google.cloud.key"));
    }

    public GoogleCloudVision(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public void setMaxLabels(int maxLabels) {
        this.maxLabels = maxLabels;
    }

    @Override
    public List<String> classify(File image) throws Exception {
        return this.classify(image, this.maxLabels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> classify(File image, int maxNumberOfLabels) throws IOException {
        ArrayList<String> labels = new ArrayList<String>();
        if (maxNumberOfLabels < 1) {
            maxNumberOfLabels = 1;
        }
        HttpClient httpClient = new HttpClient();
        String body = "{\"requests\":[{\"image\":{\"content\":\"XXX\"},\"features\":[{\"type\":\"LABEL_DETECTION\",\"maxResults\":" + maxNumberOfLabels + "}]}]}";
        FileInputStream fileInputStreamReader = new FileInputStream(image);
        byte[] bytes = new byte[(int)image.length()];
        fileInputStreamReader.read(bytes);
        String encodedFile = Base64.getEncoder().encodeToString(bytes);
        body = body.replace("XXX", encodedFile);
        PostMethod post = new PostMethod("https://vision.googleapis.com/v1/images:annotate?key=" + this.apiKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity(body.toString()));
        try {
            httpClient.executeMethod((HttpMethod)post);
            String methodResult = IOUtils.toString((InputStream)post.getResponseBodyAsStream());
            JsonObject responseJson = new JsonObject(methodResult);
            JsonArray responses = responseJson.tryGetJsonArray("responses");
            JsonArray labelAnnotations = responses.tryGetJsonObject(0).tryGetJsonArray("labelAnnotations");
            for (int i = 0; i < labelAnnotations.size(); ++i) {
                labels.add(labelAnnotations.tryGetJsonObject(i).tryGetString("description"));
                if (labels.size() < maxNumberOfLabels) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        return labels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String recognizeText(File image) throws IOException {
        HttpClient httpClient = new HttpClient();
        String body = "{\"requests\": [{\"image\":{\"content\":\"XXX\"},\"features\": [{\"type\": \"DOCUMENT_TEXT_DETECTION\"}]}]}";
        FileInputStream fileInputStreamReader = new FileInputStream(image);
        byte[] bytes = new byte[(int)image.length()];
        fileInputStreamReader.read(bytes);
        String encodedFile = Base64.getEncoder().encodeToString(bytes);
        body = body.replace("XXX", encodedFile);
        PostMethod post = new PostMethod("https://vision.googleapis.com/v1/images:annotate?key=" + this.apiKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity(body.toString()));
        try {
            httpClient.executeMethod((HttpMethod)post);
            String methodResult = IOUtils.toString((InputStream)post.getResponseBodyAsStream());
            JsonObject responseJson = new JsonObject(methodResult);
            JsonArray responses = responseJson.tryGetJsonArray("responses");
            String string = responses.tryGetJsonObject(0).tryGetJsonObject("fullTextAnnotation").tryGetString("text");
            return string;
        }
        catch (JsonException e) {
            e.printStackTrace();
        }
        finally {
            post.releaseConnection();
        }
        return "";
    }

    public static void main(String ... args) throws Exception {
        GoogleCloudVision cv = new GoogleCloudVision("apiKey");
        List<String> labels = cv.classify(new File("dog.jpg"), 10);
        CollectionHelper.print(labels);
        System.out.println(cv.recognizeText(new File("data/temp/menu.jpg")));
    }
}

