/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.classifiers.cloudservices;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.apache.commons.configuration.Configuration;
import ws.palladian.classifiers.cloudservices.ImageClassifier;
import ws.palladian.core.Category;
import ws.palladian.core.CategoryEntries;
import ws.palladian.core.ImmutableCategory;
import ws.palladian.core.ImmutableCategoryEntries;
import ws.palladian.retrieval.parser.json.JsonArray;
import ws.palladian.retrieval.parser.json.JsonException;
import ws.palladian.retrieval.parser.json.JsonObject;

public class Imagga
implements ImageClassifier {
    private final String apiKey;
    private final String apiSecret;
    private static final String apiKeyKey = "api.imagga.key";
    private static final String apiSecretKey = "api.imagga.secret";
    private int maxLabels = 10;

    public Imagga(String apiKey, String apiSecret) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    public Imagga(Configuration configuration) {
        this(configuration.getString(apiKeyKey), configuration.getString(apiSecretKey));
    }

    @Override
    public void setMaxLabels(int maxLabels) {
        this.maxLabels = maxLabels;
    }

    @Override
    public List<String> classify(File image) throws Exception {
        CategoryEntries centries = this.classifyWithProbability(image);
        ArrayList<String> names = new ArrayList<String>();
        for (Category centry : centries) {
            names.add(centry.getName());
        }
        return names;
    }

    public CategoryEntries classifyWithProbability(File image) throws Exception {
        LinkedHashMap<String, ImmutableCategory> entryMap = new LinkedHashMap<String, ImmutableCategory>();
        ImmutableCategory mostLikely = new ImmutableCategory("unknown", 0.0);
        JsonObject resultJson = this.upload(image);
        JsonArray tagsArray = Optional.ofNullable(resultJson.tryQueryJsonArray("result/tags")).orElse(new JsonArray());
        for (int i = 0; i < tagsArray.size(); ++i) {
            JsonObject jso = tagsArray.tryGetJsonObject(i);
            String tagName = jso.tryQueryString("tag/en");
            Double score = jso.tryQueryDouble("confidence") / 100.0;
            ImmutableCategory category = new ImmutableCategory(tagName, score.doubleValue());
            entryMap.put(tagName, category);
            if (score > mostLikely.getProbability()) {
                mostLikely = category;
            }
            entryMap.put(tagName, category);
            if (i >= this.maxLabels - 1) break;
        }
        return new ImmutableCategoryEntries(entryMap, (Category)mostLikely);
    }

    private JsonObject upload(File image) throws JsonException {
        String endpoint = "https://api.imagga.com/v2/tags";
        HttpResponse response = ((HttpRequestWithBody)Unirest.post((String)endpoint).basicAuth(this.apiKey, this.apiSecret)).field("image", image).asJson();
        return new JsonObject(response.getBody().toString());
    }

    public static void main(String ... args) throws Exception {
        new Imagga("apiKey", "apiSecret").classify(new File("test.jpg"));
    }
}

