/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.classifiers.cloudservices;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import ws.palladian.classifiers.cloudservices.ImageClassifier;
import ws.palladian.core.Category;
import ws.palladian.core.CategoryEntries;
import ws.palladian.core.ImmutableCategory;
import ws.palladian.core.ImmutableCategoryEntries;
import ws.palladian.helper.collection.CollectionHelper;
import ws.palladian.retrieval.parser.json.JsonArray;
import ws.palladian.retrieval.parser.json.JsonObject;

public class MicrosoftComputerVision
implements ImageClassifier {
    private final String endpoint;
    private final String apiKey;
    private int maxLabels = 10;

    public MicrosoftComputerVision(Configuration config) {
        this.endpoint = config.getString("api.microsoft.computevision.endpoint");
        this.apiKey = config.getString("api.microsoft.computevision.key");
    }

    public MicrosoftComputerVision(String endpoint, String apiKey) {
        this.endpoint = endpoint;
        this.apiKey = apiKey;
    }

    @Override
    public void setMaxLabels(int maxLabels) {
        this.maxLabels = maxLabels;
    }

    @Override
    public List<String> classify(File image) throws Exception {
        CategoryEntries centries = this.classifyWithProbability(image);
        ArrayList<String> names = new ArrayList<String>();
        for (Category centry : centries) {
            names.add(centry.getName());
        }
        return names;
    }

    public CategoryEntries classifyWithProbability(File image) throws IOException {
        ImmutableCategory mostLikely;
        LinkedHashMap<String, ImmutableCategory> entryMap;
        block5: {
            entryMap = new LinkedHashMap<String, ImmutableCategory>();
            mostLikely = new ImmutableCategory("unknown", 0.0);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            try {
                URIBuilder builder = new URIBuilder(this.endpoint + "/analyze");
                builder.setParameter("visualFeatures", "Tags");
                builder.setParameter("language", "en");
                URI uri = builder.build();
                HttpPost request = new HttpPost(uri);
                request.setHeader("Ocp-Apim-Subscription-Key", this.apiKey);
                request.setHeader("Content-Type", "application/octet-stream");
                FileEntity reqEntity = new FileEntity(image);
                request.setEntity((HttpEntity)reqEntity);
                HttpResponse response = httpclient.execute((HttpUriRequest)request);
                HttpEntity entity = response.getEntity();
                if (entity == null) break block5;
                JsonObject responseJson = new JsonObject(EntityUtils.toString((HttpEntity)entity));
                JsonArray tags = Optional.ofNullable(responseJson.tryGetJsonArray("tags")).orElse(new JsonArray());
                for (int i = 0; i < tags.size(); ++i) {
                    String tagName = tags.tryGetJsonObject(i).tryGetString("name");
                    Double score = tags.tryGetJsonObject(i).tryGetDouble("confidence");
                    ImmutableCategory category = new ImmutableCategory(tagName, score.doubleValue());
                    entryMap.put(tagName, category);
                    if (score > mostLikely.getProbability()) {
                        mostLikely = category;
                    }
                    if (i < this.maxLabels - 1) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ImmutableCategoryEntries(entryMap, (Category)mostLikely);
    }

    public static void main(String ... args) throws Exception {
        CategoryEntries labels = new MicrosoftComputerVision("endpoint", "apiKey").classifyWithProbability(new File("dog.jpg"));
        CollectionHelper.print((Iterable)labels);
    }
}

