/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.classifiers.cloudservices;

import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamAuthenticator;
import com.ibm.watson.visual_recognition.v3.VisualRecognition;
import com.ibm.watson.visual_recognition.v3.model.ClassResult;
import com.ibm.watson.visual_recognition.v3.model.ClassifiedImage;
import com.ibm.watson.visual_recognition.v3.model.ClassifiedImages;
import com.ibm.watson.visual_recognition.v3.model.ClassifierResult;
import com.ibm.watson.visual_recognition.v3.model.ClassifyOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import ws.palladian.classifiers.cloudservices.ImageClassifier;
import ws.palladian.core.Category;
import ws.palladian.core.CategoryEntries;
import ws.palladian.core.ImmutableCategory;
import ws.palladian.core.ImmutableCategoryEntries;
import ws.palladian.helper.collection.CollectionHelper;

public class WatsonVisualRecognition
implements ImageClassifier {
    private static final String apiKeyKey = "api.watson.key";
    private VisualRecognition service;
    private int maxLabels = 10;

    public WatsonVisualRecognition(Configuration configuration) {
        this(configuration.getString(apiKeyKey));
    }

    public WatsonVisualRecognition(String apiKey) {
        IamAuthenticator authenticator = new IamAuthenticator(apiKey);
        this.service = new VisualRecognition("2018-03-19", (Authenticator)authenticator);
        this.service.setServiceUrl("https://api.eu-de.visual-recognition.watson.cloud.ibm.com");
    }

    @Override
    public void setMaxLabels(int maxLabels) {
        this.maxLabels = maxLabels;
    }

    @Override
    public List<String> classify(File image) throws IOException {
        return this.classify(image, "default");
    }

    public List<String> classify(File image, String modelName) throws IOException {
        CategoryEntries centries = this.classifyWithProbability(image, modelName);
        ArrayList<String> names = new ArrayList<String>();
        for (Category centry : centries) {
            names.add(centry.getName());
        }
        return names;
    }

    public CategoryEntries classifyWithProbability(File image) throws IOException {
        return this.classifyWithProbability(image, "default");
    }

    public CategoryEntries classifyWithProbability(File image, String classifierIds) throws IOException {
        LinkedHashMap<String, ImmutableCategory> entryMap = new LinkedHashMap<String, ImmutableCategory>();
        ImmutableCategory mostLikely = new ImmutableCategory("unknown", 0.0);
        FileInputStream imagesStream = new FileInputStream(image);
        ClassifyOptions classifyOptions = new ClassifyOptions.Builder().imagesFile((InputStream)imagesStream).imagesFilename(image.getName()).classifierIds(Arrays.asList(classifierIds)).build();
        ClassifiedImages result = (ClassifiedImages)this.service.classify(classifyOptions).execute().getResult();
        List images = result.getImages();
        block0: for (ClassifiedImage imageClassification : images) {
            Iterator iterator = imageClassification.getClassifiers().iterator();
            if (!iterator.hasNext()) continue;
            ClassifierResult visualClassifier = (ClassifierResult)iterator.next();
            for (ClassResult visualClass : visualClassifier.getClasses()) {
                ImmutableCategory category = new ImmutableCategory(visualClass.getXClass(), (double)visualClass.getScore().floatValue());
                entryMap.put(visualClass.getXClass(), category);
                if ((double)visualClass.getScore().floatValue() > mostLikely.getProbability()) {
                    mostLikely = category;
                }
                if (entryMap.keySet().size() < this.maxLabels) continue;
                continue block0;
            }
        }
        return new ImmutableCategoryEntries(entryMap, (Category)mostLikely);
    }

    public static void main(String ... args) throws Exception {
        WatsonVisualRecognition watsonRecognizer = new WatsonVisualRecognition("apiKey");
        CategoryEntries labels = watsonRecognizer.classifyWithProbability(new File("food.jpg"), "food");
        CollectionHelper.print((Iterable)labels);
    }
}

