/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.clustering;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.math3.ml.clustering.DoublePoint;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import ws.palladian.clustering.Cluster;
import ws.palladian.clustering.Clusterer;
import ws.palladian.clustering.ImmutableCluster;

public final class CommonsKMeansClusterer
implements Clusterer {
    private final int numClusters;

    public CommonsKMeansClusterer(int numClusters) {
        this.numClusters = numClusters;
    }

    @Override
    public Collection<Cluster> cluster(Iterable<double[]> vectors) {
        List clusterables = StreamSupport.stream(vectors.spliterator(), false).map(v -> new DoublePoint(v)).collect(Collectors.toList());
        KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(this.numClusters);
        List clusters = clusterer.cluster(clusterables);
        return clusters.stream().map(c -> new ImmutableCluster(c.getCenter().getPoint())).collect(Collectors.toList());
    }
}

