/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.clustering;

import java.util.Arrays;
import ws.palladian.clustering.Cluster;

public final class ImmutableCluster
implements Cluster {
    private final double[] center;
    private int size;

    public ImmutableCluster(double[] center) {
        this(center, -1);
    }

    public ImmutableCluster(double[] center, int size) {
        this.center = center;
        this.size = size;
    }

    @Override
    public double[] center() {
        return this.center;
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [center=").append(Arrays.toString(this.center));
        if (this.size != -1) {
            stringBuilder.append(", size=").append(this.size);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

