/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.dataset;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ws.palladian.helper.io.FileHelper;
import ws.palladian.retrieval.parser.json.JsonException;
import ws.palladian.retrieval.parser.json.JsonObject;

public class ImageDataset {
    public static final int TRAIN = 1;
    public static final int TEST = 2;
    private String name;
    private String basePath;
    private String folderedPath;
    private String separator;
    private String trainFilePath;
    private String testFilePath;
    private int numberOfClasses;
    private List<String> classNames = new ArrayList<String>();

    public ImageDataset(File dataset) throws IOException, JsonException {
        JsonObject json = new JsonObject(FileHelper.readFileToString((File)dataset));
        System.out.println(json);
        this.basePath = dataset.getParentFile().getAbsolutePath() + File.separator;
        this.folderedPath = this.basePath + json.tryGetString("folderedPath");
        this.separator = Optional.ofNullable(json.tryGetString("separator")).orElse("\t");
        this.trainFilePath = json.tryGetString("train");
        this.testFilePath = json.tryGetString("test");
        this.name = Optional.ofNullable(json.tryGetString("name")).orElse("unnamed");
        this.numberOfClasses = json.getInt("numberOfClasses");
    }

    public List<String> getClassNames() {
        if (this.classNames.isEmpty()) {
            File[] files;
            for (File file : files = new File(this.getFolderedPath()).listFiles()) {
                this.classNames.add(file.getName());
            }
        }
        return this.classNames;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumberOfClasses() {
        return this.numberOfClasses;
    }

    public void setNumberOfClasses(int numberOfClasses) {
        this.numberOfClasses = numberOfClasses;
    }

    public String getFolderedPath() {
        return this.folderedPath;
    }

    public void setFolderedPath(String folderedPath) {
        this.folderedPath = folderedPath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getTrainFilePath() {
        return this.trainFilePath;
    }

    public void setTrainFilePath(String trainFilePath) {
        this.trainFilePath = trainFilePath;
    }

    public String getTestFilePath() {
        return this.testFilePath;
    }

    public void setTestFilePath(String testFilePath) {
        this.testFilePath = testFilePath;
    }

    public File getTrainFile() {
        return new File(this.basePath + this.trainFilePath);
    }

    public File getTestFile() {
        return new File(this.basePath + this.testFilePath);
    }

    public File getTrainFeaturesFile() {
        return new File(this.basePath + "train-features.csv");
    }

    public File getTestFeaturesFile() {
        return new File(this.basePath + "test-features.csv");
    }
}

