/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.evaluation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.palladian.classification.DatasetManager;
import ws.palladian.classification.text.BayesScorer;
import ws.palladian.classification.text.FeatureSettingBuilder;
import ws.palladian.classification.text.PalladianTextClassifier;
import ws.palladian.classification.utils.CsvDatasetReader;
import ws.palladian.classification.utils.CsvDatasetReaderConfig;
import ws.palladian.core.Instance;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.core.dataset.Dataset;
import ws.palladian.core.dataset.DefaultDataset;
import ws.palladian.core.value.ImmutableTextValue;
import ws.palladian.dataset.ImageDataset;
import ws.palladian.dataset.ImageValue;
import ws.palladian.features.BlockCodeExtractor;
import ws.palladian.features.BoundsFeatureExtractor;
import ws.palladian.features.ColorFeatureExtractor;
import ws.palladian.features.EdginessFeatureExtractor;
import ws.palladian.features.FeatureExtractor;
import ws.palladian.features.FrequencyFeatureExtractor;
import ws.palladian.features.GridSimilarityExtractor;
import ws.palladian.features.LocalFeatureExtractor;
import ws.palladian.features.RegionFeatureExtractor;
import ws.palladian.features.StatisticsFeatureExtractor;
import ws.palladian.features.SymmetryFeatureExtractor;
import ws.palladian.features.color.ColorExtractor;
import ws.palladian.features.color.HSB;
import ws.palladian.features.color.Luminosity;
import ws.palladian.features.color.RGB;
import ws.palladian.helper.ProgressMonitor;
import ws.palladian.helper.ProgressReporter;
import ws.palladian.helper.date.DateHelper;
import ws.palladian.helper.functional.Predicates;
import ws.palladian.helper.io.FileHelper;
import ws.palladian.kaggle.restaurants.Experimenter;
import ws.palladian.retrieval.parser.json.JsonException;
import ws.palladian.utils.CsvDatasetWriter;

public class Evaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Evaluator.class);
    private static final int NUM_THREADS = 6;

    public static void extractFeatures(Collection<FeatureExtractor> extractors, ImageDataset imageDataset, int type) throws IOException {
        File file = null;
        String stringType = "";
        if (type == 2) {
            stringType = "test";
            file = imageDataset.getTestFile();
        } else if (type == 1) {
            stringType = "train";
            file = imageDataset.getTrainFile();
        }
        File csvOutput = new File(imageDataset.getBasePath() + stringType + "-features.csv");
        CsvDatasetReaderConfig.Builder csvConfigBuilder = CsvDatasetReaderConfig.filePath((File)file);
        csvConfigBuilder.setFieldSeparator(imageDataset.getSeparator());
        CsvDatasetReader instances = csvConfigBuilder.create();
        Evaluator.extractFeatures((Iterable<Instance>)instances, csvOutput, extractors, imageDataset.getBasePath());
    }

    public static void extractFeatures(Iterable<Instance> instances, File csvOutput, Collection<FeatureExtractor> extractors, String basePath) throws IOException {
        FileHelper.delete((File)csvOutput);
        try (CsvDatasetWriter writer = new CsvDatasetWriter(csvOutput);){
            ExecutorService executor = Executors.newFixedThreadPool(6);
            ProgressMonitor progressMonitor = new ProgressMonitor(0.01);
            int count = 0;
            for (Instance instance : instances) {
                executor.execute(new FeatureExtractionTask(instance, extractors, writer, basePath, (ProgressReporter)progressMonitor));
                ++count;
            }
            progressMonitor.startTask("Extracting features using " + extractors.size() + " extractors", (long)count);
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void evaluateTrainTestSplits() throws IOException, JsonException {
        ArrayList<FeatureExtractor> extractors = new ArrayList<FeatureExtractor>();
        extractors.add(new BlockCodeExtractor());
        Predicate blockCodeFeatures = Predicates.regex((String)"text");
        ImageDataset imageDataset = new ImageDataset(new File("E:\\Projects\\Programming\\Java\\WebKnox\\data\\temp\\images\\recipes50\\dataset.json"));
        File resultDirectory = new File(imageDataset.getBasePath() + "results-" + DateHelper.getCurrentDatetime());
        for (int i = 10; i <= 90; i += 10) {
            DatasetManager.splitIndex((String)(imageDataset.getBasePath() + "index.txt"), (int)i, (String)imageDataset.getSeparator(), (boolean)true);
            imageDataset.setTrainFilePath("train-" + i + ".txt");
            imageDataset.setTrainFilePath("test-" + (100 - i) + ".txt");
            Evaluator.extractFeatures(extractors, imageDataset, 1);
            Evaluator.extractFeatures(extractors, imageDataset, 2);
            CsvDatasetReaderConfig.Builder csvConfigBuilder = CsvDatasetReaderConfig.filePath((File)imageDataset.getTrainFeaturesFile());
            csvConfigBuilder.setFieldSeparator(";");
            csvConfigBuilder.parser("text", ImmutableTextValue.PARSER);
            CsvDatasetReader trainingInstances = csvConfigBuilder.create();
            csvConfigBuilder = CsvDatasetReaderConfig.filePath((File)imageDataset.getTestFeaturesFile());
            csvConfigBuilder.setFieldSeparator(";");
            csvConfigBuilder.parser("text", ImmutableTextValue.PARSER);
            CsvDatasetReader csvDatasetReader = csvConfigBuilder.create();
        }
    }

    public static void runBlockCodeExperiments(ImageDataset imageDataset) throws IOException, JsonException {
        Predicate blockCodeFeatures = Predicates.regex((String)"text");
        File resultDirectory = new File(imageDataset.getBasePath() + "blockcode-evaluation-results-" + DateHelper.getCurrentDatetime());
        BlockCodeExtractor.Colors[] numberOfColors = new BlockCodeExtractor.Colors[]{BlockCodeExtractor.Colors.TWENTY_EIGHT, BlockCodeExtractor.Colors.TWENTY_EIGHT_AND_BRIGHTNESS_2, BlockCodeExtractor.Colors.TWENTY_EIGHT_AND_BRIGHTNESS_3, BlockCodeExtractor.Colors.TWENTY_EIGHT_AND_BRIGHTNESS_4, BlockCodeExtractor.Colors.TWENTY_EIGHT_AND_BRIGHTNESS_8, BlockCodeExtractor.Colors.TWENTY_EIGHT_AND_BRIGHTNESS_10, BlockCodeExtractor.Colors.FIFTY_ONE};
        int[] pixelationSizes = new int[]{5, 6, 7, 8, 9, 10, 11};
        BlockCodeExtractor.BlockSize[] blockSizes = new BlockCodeExtractor.BlockSize[]{BlockCodeExtractor.BlockSize.ONE_BY_ONE, BlockCodeExtractor.BlockSize.TWO_BY_TWO, BlockCodeExtractor.BlockSize.THREE_BY_THREE};
        BlockCodeExtractor.BlockSize[] imageSections = new BlockCodeExtractor.BlockSize[]{BlockCodeExtractor.BlockSize.TWO_BY_TWO, BlockCodeExtractor.BlockSize.THREE_BY_THREE, BlockCodeExtractor.BlockSize.FOUR_BY_FOUR};
        boolean[] includeNumberOfColors = new boolean[]{false, true};
        int combinations = numberOfColors.length * pixelationSizes.length * blockSizes.length * imageSections.length * includeNumberOfColors.length;
        LOGGER.info("block code experiments with " + combinations + " combinations");
        int c = 1;
        for (BlockCodeExtractor.Colors numberOfColor : numberOfColors) {
            for (int pixelationSize : pixelationSizes) {
                for (BlockCodeExtractor.BlockSize blockSize : blockSizes) {
                    for (BlockCodeExtractor.BlockSize imageSection : imageSections) {
                        for (boolean includeNumberOfColor : includeNumberOfColors) {
                            LOGGER.info("======================== running combination " + c + "/" + combinations + " ========================");
                            BlockCodeExtractor blockCodeExtractor = new BlockCodeExtractor(numberOfColor, pixelationSize, blockSize, imageSection, includeNumberOfColor);
                            ArrayList<FeatureExtractor> extractors = new ArrayList<FeatureExtractor>();
                            extractors.add(blockCodeExtractor);
                            Evaluator.extractFeatures(extractors, imageDataset, 1);
                            Evaluator.extractFeatures(extractors, imageDataset, 2);
                            CsvDatasetReaderConfig.Builder csvConfigBuilder = CsvDatasetReaderConfig.filePath((File)imageDataset.getTrainFeaturesFile());
                            csvConfigBuilder.setFieldSeparator(";");
                            csvConfigBuilder.parser("text", ImmutableTextValue.PARSER);
                            CsvDatasetReader trainingInstances = csvConfigBuilder.create();
                            csvConfigBuilder = CsvDatasetReaderConfig.filePath((File)imageDataset.getTestFeaturesFile());
                            csvConfigBuilder.setFieldSeparator(";");
                            csvConfigBuilder.parser("text", ImmutableTextValue.PARSER);
                            CsvDatasetReader testingInstances = csvConfigBuilder.create();
                            ++c;
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws IOException, JsonException {
        System.out.println("Run evaluator");
        String datasetPath = "C:\\Workspace\\data\\recipes50\\dataset.json";
        if (args.length > 0) {
            datasetPath = args[0];
        }
        ImageDataset imageDataset = new ImageDataset(new File(datasetPath));
        ColorExtractor[] colorExtractors = new ColorExtractor[]{Luminosity.LUMINOSITY, RGB.RED, RGB.GREEN, RGB.BLUE, HSB.HUE, HSB.SATURATION, HSB.BRIGHTNESS};
        ArrayList<FeatureExtractor> extractors = new ArrayList<FeatureExtractor>();
        extractors.add(new StatisticsFeatureExtractor(colorExtractors));
        extractors.add(new LocalFeatureExtractor(2, new StatisticsFeatureExtractor(colorExtractors)));
        extractors.add(new LocalFeatureExtractor(3, new StatisticsFeatureExtractor(colorExtractors)));
        extractors.add(new LocalFeatureExtractor(4, new StatisticsFeatureExtractor(colorExtractors)));
        extractors.add(BoundsFeatureExtractor.BOUNDS);
        extractors.add(ColorFeatureExtractor.COLOR);
        extractors.add(new SymmetryFeatureExtractor(colorExtractors));
        extractors.add(RegionFeatureExtractor.REGION);
        extractors.add(FrequencyFeatureExtractor.FREQUENCY);
        extractors.add(new GridSimilarityExtractor(2));
        extractors.add(new GridSimilarityExtractor(3));
        extractors.add(new GridSimilarityExtractor(4));
        extractors.add(EdginessFeatureExtractor.EDGINESS);
        extractors.clear();
        extractors.add(new BlockCodeExtractor());
        Evaluator.extractFeatures(extractors, imageDataset, 1);
        Evaluator.extractFeatures(extractors, imageDataset, 2);
        CsvDatasetReaderConfig.Builder csvConfigBuilder = CsvDatasetReaderConfig.filePath((File)imageDataset.getTrainFeaturesFile());
        csvConfigBuilder.parser("text", ImmutableTextValue.PARSER);
        csvConfigBuilder.setFieldSeparator(";");
        CsvDatasetReader trainingInstances = csvConfigBuilder.create();
        csvConfigBuilder = CsvDatasetReaderConfig.filePath((File)imageDataset.getTestFeaturesFile());
        csvConfigBuilder.parser("text", ImmutableTextValue.PARSER);
        CsvDatasetReader testingInstances = csvConfigBuilder.create();
        File resultDirectory = new File(imageDataset.getBasePath() + "results-" + DateHelper.getCurrentDatetime());
        DefaultDataset trainingDs = new DefaultDataset((Iterable)trainingInstances);
        DefaultDataset testDs = new DefaultDataset((Iterable)testingInstances);
        Experimenter experimenter = new Experimenter((Dataset)trainingDs, (Dataset)testDs, resultDirectory);
        Predicate surfFeatures = Predicates.regex((String)"SURF.*");
        Predicate siftFeatures = Predicates.regex((String)"SIFT.*");
        Predicate boundsFeatures = Predicates.regex((String)"width|height|ratio");
        Predicate colorFeatures = Predicates.regex((String)"main_color.*");
        Predicate statisticsFeatures = Predicates.regex((String)"(?!(cell|4x4)-).*_(max|mean|min|range|stdDev|relStdDev|sum|count|\\d{2}-percentile)");
        Predicate local4StatisticsFeatures = Predicates.regex((String)"cell-\\d/4.*");
        Predicate local9StatisticsFeatures = Predicates.regex((String)"cell-\\d/9.*");
        Predicate symmetryFeatures = Predicates.regex((String)"symmetry-.*");
        Predicate edginessFeatures = Predicates.regex((String)"edginess-.*");
        Predicate regionFeatures = Predicates.regex((String)".*_region.*");
        Predicate frequencyFeatures = Predicates.regex((String)"frequency-.*");
        Predicate gridFeatures = Predicates.regex((String)"4x4-similarity_.*");
        Predicate blockCodeFeatures = Predicates.regex((String)"text");
        Predicate allQuantitativeFeatures = Predicates.or((Predicate[])new Predicate[]{colorFeatures, statisticsFeatures, symmetryFeatures, local4StatisticsFeatures, local9StatisticsFeatures, regionFeatures, edginessFeatures, frequencyFeatures, gridFeatures});
        List<Predicate> allCombinations = Arrays.asList(colorFeatures, statisticsFeatures, symmetryFeatures, regionFeatures, frequencyFeatures, gridFeatures, allQuantitativeFeatures);
        List<Predicate> smallList = Arrays.asList(blockCodeFeatures);
        experimenter.withClassifier(new PalladianTextClassifier(FeatureSettingBuilder.words((int)1, (int)4).create(), (PalladianTextClassifier.Scorer)new BayesScorer(new BayesScorer.Options[]{BayesScorer.Options.FREQUENCIES, BayesScorer.Options.LAPLACE, BayesScorer.Options.PRIORS})), smallList);
        experimenter.run();
    }

    private static final class FeatureExtractionTask
    implements Runnable {
        private String basePath = "";
        private final Instance instance;
        private final Collection<FeatureExtractor> extractors;
        private final CsvDatasetWriter writer;
        private final ProgressReporter progressMonitor;

        FeatureExtractionTask(Instance instance, Collection<FeatureExtractor> extractors, CsvDatasetWriter writer, String basePath, ProgressReporter progressMonitor) {
            this.instance = instance;
            this.extractors = extractors;
            this.writer = writer;
            this.basePath = basePath;
            this.progressMonitor = progressMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InstanceBuilder instanceBuilder = new InstanceBuilder().add(this.instance.getVector());
            for (FeatureExtractor extractor : this.extractors) {
                String imagePath = String.valueOf(this.instance.getVector().get((Object)"image"));
                ImageValue imageValue = new ImageValue(new File(this.basePath + imagePath));
                try {
                    instanceBuilder.add(extractor.extract(imageValue.getImage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("problem with file " + imagePath + ", base path: " + this.basePath);
                }
            }
            CsvDatasetWriter csvDatasetWriter = this.writer;
            synchronized (csvDatasetWriter) {
                this.writer.append(instanceBuilder.create(this.instance.getCategory()));
                this.progressMonitor.increment();
            }
        }
    }
}

