/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.features;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import ws.palladian.core.FeatureVector;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.core.value.ImmutableTextValue;
import ws.palladian.core.value.Value;
import ws.palladian.extraction.multimedia.ColorSpaceConverter;
import ws.palladian.extraction.multimedia.ImageHandler;
import ws.palladian.features.FeatureExtractor;
import ws.palladian.helper.collection.Bag;
import ws.palladian.helper.collection.CollectionHelper;

public class BlockCodeExtractor
implements FeatureExtractor {
    private List<Color> palette = new ArrayList<Color>();
    private Colors numberOfColors = Colors.TWENTY_EIGHT;
    private int pixelationSize = 8;
    private BlockSize blockSize = BlockSize.THREE_BY_THREE;
    private BlockSize imageSections = BlockSize.THREE_BY_THREE;
    private boolean numberOfColorsInCode = false;

    public BlockCodeExtractor(Colors numberOfColors, int pixelationSize, BlockSize blockSize, BlockSize imageSections, boolean numberOfColorsInCode) {
        this.numberOfColors = numberOfColors;
        this.pixelationSize = pixelationSize;
        this.blockSize = blockSize;
        this.imageSections = imageSections;
        this.numberOfColorsInCode = numberOfColorsInCode;
        this.init();
    }

    public BlockCodeExtractor() {
        this.init();
    }

    private void init() {
        this.palette.add(Color.BLACK);
        this.palette.add(Color.WHITE);
        switch (this.numberOfColors) {
            case GREY_SCALE_5: {
                this.palette.add(Color.LIGHT_GRAY);
                this.palette.add(Color.GRAY);
                this.palette.add(Color.DARK_GRAY);
                break;
            }
            case EIGHT: {
                this.palette.add(new Color(7, 139, 91));
                this.palette.add(new Color(234, 227, 49));
                this.palette.add(new Color(235, 139, 47));
                this.palette.add(new Color(221, 38, 44));
                this.palette.add(new Color(107, 51, 133));
                this.palette.add(new Color(36, 143, 181));
                break;
            }
            case FOURTEEN: {
                this.palette.add(new Color(7, 139, 91));
                this.palette.add(new Color(134, 185, 53));
                this.palette.add(new Color(234, 227, 49));
                this.palette.add(new Color(245, 194, 46));
                this.palette.add(new Color(235, 139, 47));
                this.palette.add(new Color(229, 95, 45));
                this.palette.add(new Color(221, 38, 44));
                this.palette.add(new Color(190, 0, 121));
                this.palette.add(new Color(107, 51, 133));
                this.palette.add(new Color(71, 71, 145));
                this.palette.add(new Color(53, 104, 169));
                this.palette.add(new Color(36, 143, 181));
                break;
            }
            case TWENTY_EIGHT: 
            case FIFTY_ONE: 
            case TWENTY_EIGHT_AND_BRIGHTNESS_2: 
            case TWENTY_EIGHT_AND_BRIGHTNESS_3: 
            case TWENTY_EIGHT_AND_BRIGHTNESS_4: 
            case TWENTY_EIGHT_AND_BRIGHTNESS_6: 
            case TWENTY_EIGHT_AND_BRIGHTNESS_8: 
            case TWENTY_EIGHT_AND_BRIGHTNESS_10: {
                this.palette.add(Color.GRAY);
                this.palette.add(Color.LIGHT_GRAY);
                this.palette.add(Color.DARK_GRAY);
                this.palette.add(new Color(7, 139, 91));
                this.palette.add(new Color(70, 162, 71));
                this.palette.add(new Color(134, 185, 53));
                this.palette.add(new Color(184, 206, 51));
                this.palette.add(new Color(234, 227, 49));
                this.palette.add(new Color(240, 210, 47));
                this.palette.add(new Color(245, 194, 46));
                this.palette.add(new Color(240, 166, 46));
                this.palette.add(new Color(235, 139, 47));
                this.palette.add(new Color(232, 117, 46));
                this.palette.add(new Color(229, 95, 45));
                this.palette.add(new Color(225, 67, 45));
                this.palette.add(new Color(221, 38, 44));
                this.palette.add(new Color(206, 19, 82));
                this.palette.add(new Color(190, 0, 121));
                this.palette.add(new Color(149, 26, 127));
                this.palette.add(new Color(107, 51, 133));
                this.palette.add(new Color(94, 61, 139));
                this.palette.add(new Color(71, 71, 145));
                this.palette.add(new Color(62, 88, 157));
                this.palette.add(new Color(53, 104, 169));
                this.palette.add(new Color(45, 124, 175));
                this.palette.add(new Color(36, 143, 181));
            }
        }
        if (this.numberOfColors == Colors.FIFTY_ONE) {
            int c = 0;
            ArrayList<Color> colorsToAdd = new ArrayList<Color>();
            for (Color color : this.palette) {
                if (++c <= 5) continue;
                double[] doubles = ColorSpaceConverter.rgbToHsb((Color)color);
                doubles[2] = 64.0;
                int[] ints = ColorSpaceConverter.hsbToRrb((double[])doubles);
                Color shiftedColor1 = new Color(ints[0], ints[1], ints[2]);
                doubles[2] = 192.0;
                ints = ColorSpaceConverter.hsbToRrb((double[])doubles);
                Color shiftedColor2 = new Color(ints[0], ints[1], ints[2]);
                colorsToAdd.add(shiftedColor1);
                colorsToAdd.add(shiftedColor2);
            }
            this.palette.addAll(colorsToAdd);
        }
    }

    @Override
    public FeatureVector extract(BufferedImage image) {
        InstanceBuilder instanceBuilder = new InstanceBuilder();
        BufferedImage pixelatedImage = ImageHandler.pixelate((BufferedImage)image, (int)this.pixelationSize, this.palette);
        instanceBuilder.set("text", (Value)new ImmutableTextValue(this.codeImage(pixelatedImage, this.pixelationSize)));
        return instanceBuilder.create();
    }

    private String codeImage(BufferedImage image, int pixelationSize) {
        int sectionWidth = (int)((double)image.getWidth() / (double)this.imageSections.getLength());
        int sectionHeight = (int)((double)image.getHeight() / (double)this.imageSections.getLength());
        int wordLength = this.blockSize.getLength() * pixelationSize;
        String entireCode = "";
        int i1 = (int)((double)image.getWidth() / (double)wordLength);
        int i2 = (int)((double)image.getHeight() / (double)wordLength);
        switch (this.blockSize) {
            case ONE_BY_ONE: 
            case TWO_BY_TWO: {
                for (int j = 0; j < i2; ++j) {
                    for (int i = 0; i < i1; ++i) {
                        int blockX = wordLength * i;
                        int blockY = wordLength * j;
                        int sx = (int)((double)blockX / (double)sectionWidth) + 1;
                        int sy = (int)((double)blockY / (double)sectionHeight);
                        int sectionNumber = sy * this.imageSections.getLength() + sx;
                        Color[] block = new Color[]{new Color(image.getRGB(blockX, blockY)), new Color(image.getRGB(blockX + pixelationSize, blockY)), new Color(image.getRGB(blockX, blockY + pixelationSize)), new Color(image.getRGB(blockX + pixelationSize, blockY + pixelationSize))};
                        String code = this.codeBlock(block, sectionNumber);
                        entireCode = entireCode + code + " ";
                    }
                }
                break;
            }
            case THREE_BY_THREE: {
                for (int j = 0; j < i2 - 1; ++j) {
                    for (int i = 0; i < i1 - 1; ++i) {
                        int blockX = wordLength * i;
                        int blockY = wordLength * j;
                        int sx = (int)((double)blockX / (double)sectionWidth) + 1;
                        int sy = (int)((double)blockY / (double)sectionHeight);
                        int sectionNumber = sy * this.imageSections.getLength() + sx;
                        Color[] block = new Color[]{new Color(image.getRGB(blockX, blockY)), new Color(image.getRGB(blockX + pixelationSize, blockY)), new Color(image.getRGB(blockX + 2 * pixelationSize, blockY)), new Color(image.getRGB(blockX, blockY + pixelationSize)), new Color(image.getRGB(blockX + pixelationSize, blockY + pixelationSize)), new Color(image.getRGB(blockX + 2 * pixelationSize, blockY + pixelationSize)), new Color(image.getRGB(blockX, blockY + 2 * pixelationSize)), new Color(image.getRGB(blockX + pixelationSize, blockY + 2 * pixelationSize)), new Color(image.getRGB(blockX + 2 * pixelationSize, blockY + 2 * pixelationSize))};
                        String code = this.codeBlock(block, sectionNumber);
                        entireCode = entireCode + code + " ";
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("block size must be 2x2 or 3x3");
            }
        }
        return entireCode.trim();
    }

    private String codeBlock(Color[] block, int imageSection) {
        String mainColorCode = "";
        int shapeCode = 0;
        Bag colorCounter = Bag.create();
        double averageBlockBrightness = 0.0;
        for (Color aBlock : block) {
            colorCounter.add((Object)aBlock);
            double[] doubles = ColorSpaceConverter.rgbToHsb((Color)aBlock);
            averageBlockBrightness += doubles[2];
        }
        averageBlockBrightness /= (double)block.length;
        Bag sorted = colorCounter.createSorted(CollectionHelper.Order.DESCENDING);
        LinkedHashMap<Color, Integer> frequencies = new LinkedHashMap<Color, Integer>();
        Iterator iterator = sorted.uniqueItems().iterator();
        if (iterator.hasNext()) {
            Color s = (Color)iterator.next();
            int pos = 97;
            for (Color color : this.palette) {
                if (s.equals(color)) {
                    mainColorCode = Character.toString((char)pos);
                    break;
                }
                ++pos;
            }
            frequencies.put(s, sorted.count((Object)s));
        }
        int numberOfColors = sorted.uniqueItems().size();
        switch (this.blockSize) {
            case ONE_BY_ONE: {
                shapeCode = 1;
                break;
            }
            case TWO_BY_TWO: {
                if (numberOfColors == 1) {
                    shapeCode = 1;
                    break;
                }
                if (block[0].equals(block[2]) && block[1].equals(block[3])) {
                    shapeCode = 2;
                    break;
                }
                if (block[0].equals(block[1]) && block[2].equals(block[3])) {
                    shapeCode = 3;
                    break;
                }
                if (!block[0].equals(block[3]) || !block[1].equals(block[2])) break;
                shapeCode = 4;
                break;
            }
            case THREE_BY_THREE: {
                if (numberOfColors == 1) {
                    shapeCode = 1;
                    break;
                }
                if (block[0].equals(block[3]) && block[0].equals(block[6]) || block[1].equals(block[4]) && block[1].equals(block[7]) || block[2].equals(block[5]) && block[2].equals(block[8])) {
                    shapeCode = 2;
                    break;
                }
                if (block[0].equals(block[1]) && block[0].equals(block[2]) || block[3].equals(block[4]) && block[3].equals(block[5]) || block[6].equals(block[7]) && block[6].equals(block[8])) {
                    shapeCode = 3;
                    break;
                }
                if ((!block[0].equals(block[4]) || !block[0].equals(block[8])) && (!block[2].equals(block[4]) || !block[2].equals(block[6]))) break;
                shapeCode = 4;
                break;
            }
            default: {
                throw new UnsupportedOperationException("block size must be 2x2 or 3x3");
            }
        }
        String brightness = "";
        int quantificationLevel = 0;
        switch (this.numberOfColors) {
            case TWENTY_EIGHT_AND_BRIGHTNESS_2: {
                quantificationLevel = 2;
                break;
            }
            case TWENTY_EIGHT_AND_BRIGHTNESS_3: {
                quantificationLevel = 3;
                break;
            }
            case TWENTY_EIGHT_AND_BRIGHTNESS_4: {
                quantificationLevel = 4;
                break;
            }
            case TWENTY_EIGHT_AND_BRIGHTNESS_6: {
                quantificationLevel = 6;
                break;
            }
            case TWENTY_EIGHT_AND_BRIGHTNESS_8: {
                quantificationLevel = 8;
                break;
            }
            case TWENTY_EIGHT_AND_BRIGHTNESS_10: {
                quantificationLevel = 10;
                break;
            }
        }
        if (quantificationLevel > 0) {
            int brightnessNormalized = (int)((double)quantificationLevel * averageBlockBrightness / 256.0);
            brightness = String.valueOf(brightnessNormalized);
        }
        String blockCode = "";
        if (this.numberOfColorsInCode) {
            blockCode = blockCode + numberOfColors;
        }
        if (!brightness.isEmpty()) {
            mainColorCode = brightness;
        }
        blockCode = blockCode + mainColorCode + shapeCode + Character.toString((char)(96 + imageSection)) + "!";
        return blockCode;
    }

    public static enum BlockSize {
        ONE_BY_ONE(2),
        TWO_BY_TWO(2),
        THREE_BY_THREE(3),
        FOUR_BY_FOUR(4),
        FIVE_BY_FIVE(5);

        int length;

        private BlockSize(int length) {
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }
    }

    public static enum Colors {
        GREY_SCALE_5,
        EIGHT,
        FOURTEEN,
        TWENTY_EIGHT,
        FIFTY_ONE,
        TWENTY_EIGHT_AND_BRIGHTNESS_2,
        TWENTY_EIGHT_AND_BRIGHTNESS_3,
        TWENTY_EIGHT_AND_BRIGHTNESS_4,
        TWENTY_EIGHT_AND_BRIGHTNESS_6,
        TWENTY_EIGHT_AND_BRIGHTNESS_8,
        TWENTY_EIGHT_AND_BRIGHTNESS_10;

    }
}

