/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.features;

import java.awt.image.BufferedImage;
import ws.palladian.core.FeatureVector;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.extraction.multimedia.ImageHandler;
import ws.palladian.features.FeatureExtractor;
import ws.palladian.helper.math.FatStats;
import ws.palladian.helper.math.SlimStats;

public enum FrequencyFeatureExtractor implements FeatureExtractor
{
    FREQUENCY;


    @Override
    public FeatureVector extract(BufferedImage image) {
        InstanceBuilder instanceBuilder = new InstanceBuilder();
        FatStats fatStats = ImageHandler.detectFrequencies((BufferedImage)image);
        instanceBuilder.set("frequency-mean", fatStats.getMean());
        instanceBuilder.set("frequency-median", fatStats.getMedian());
        fatStats = ImageHandler.detectFrequencies((BufferedImage)this.toDct(image));
        instanceBuilder.set("frequency-dct-mean", fatStats.getMean());
        return instanceBuilder.create();
    }

    private BufferedImage toDct(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage img = new BufferedImage(w, h, 1);
        img.getGraphics().drawImage(image, 0, 0, null);
        int[] rgb1 = new int[w * h];
        img.getRaster().getDataElements(0, 0, w, h, rgb1);
        double[] array = new double[w * h];
        for (int i = 0; i < w * h; ++i) {
            array[i] = rgb1[i] & 0xFF;
        }
        SlimStats stat = new SlimStats();
        for (int i = 0; i < w * h; ++i) {
            int val = Math.min((int)(array[i] + 128.0), 255);
            rgb1[i] = val << 16 | val << 8 | val;
            stat.add((Number)val);
        }
        img.getRaster().setDataElements(0, 0, w, h, rgb1);
        return img;
    }

    public static void main(String[] args) {
        FeatureVector extract = FREQUENCY.extract(ImageHandler.load((String)"gradient.png"));
        System.out.println(extract);
    }
}

