/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.features;

import java.awt.image.BufferedImage;
import java.util.Objects;
import ws.palladian.core.FeatureVector;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.core.value.Value;
import ws.palladian.features.FeatureExtractor;
import ws.palladian.helper.collection.Vector;

public class LocalFeatureExtractor
implements FeatureExtractor {
    private final FeatureExtractor wrapped;
    private final int divisions;

    public LocalFeatureExtractor(int divisions, FeatureExtractor wrapped) {
        if (divisions < 2) {
            throw new IllegalArgumentException("divisions must be at least 2, but was " + divisions);
        }
        this.wrapped = Objects.requireNonNull(wrapped);
        this.divisions = divisions;
    }

    @Override
    public FeatureVector extract(BufferedImage image) {
        int cellWidth = image.getWidth() / this.divisions;
        int cellHeight = image.getHeight() / this.divisions;
        BufferedImage[] cells = new BufferedImage[this.divisions * this.divisions];
        for (int xIdx = 0; xIdx < this.divisions; ++xIdx) {
            for (int yIdx = 0; yIdx < this.divisions; ++yIdx) {
                int x = xIdx * cellWidth;
                int y = yIdx * cellHeight;
                cells[xIdx * this.divisions + yIdx] = image.getSubimage(x, y, cellWidth, cellHeight);
            }
        }
        InstanceBuilder instanceBuilder = new InstanceBuilder();
        for (int i = 0; i < cells.length; ++i) {
            FeatureVector cellVector = this.wrapped.extract(cells[i]);
            for (Vector.VectorEntry entry : cellVector) {
                String cellKey = "cell-" + (i + 1) + "/" + this.divisions * this.divisions + "-" + (String)entry.key();
                instanceBuilder.set(cellKey, (Value)entry.value());
            }
        }
        return instanceBuilder.create();
    }
}

