/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.features;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.palladian.clustering.Cluster;
import ws.palladian.clustering.Clusterer;
import ws.palladian.clustering.CommonsKMeansClusterer;
import ws.palladian.core.FeatureVector;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.extraction.multimedia.ImageHandler;
import ws.palladian.features.FeatureExtractor;
import ws.palladian.helper.ProgressMonitor;
import ws.palladian.helper.ProgressReporter;
import ws.palladian.helper.StopWatch;
import ws.palladian.kaggle.restaurants.features.descriptors.DescriptorExtractor;
import ws.palladian.utils.ImageUtils;

public class PoiFeatureExtractor
implements FeatureExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiFeatureExtractor.class);
    private static final int DEFAULT_K = 200;
    private static final int NUM_THREADS = Runtime.getRuntime().availableProcessors();
    private final DescriptorExtractor strategy;
    private final List<double[]> clusters;

    public static PoiFeatureExtractor buildVocabulary(DescriptorExtractor strategy, Collection<File> imageFiles) throws IOException {
        return PoiFeatureExtractor.buildVocabulary(strategy, imageFiles, new CommonsKMeansClusterer(200));
    }

    public static PoiFeatureExtractor buildVocabulary(DescriptorExtractor strategy, Collection<File> imageFiles, Clusterer clusterer) throws IOException {
        ExecutorService executor = Executors.newFixedThreadPool(NUM_THREADS);
        ProgressMonitor progressMonitor = new ProgressMonitor(1L);
        progressMonitor.startTask("Initializing vocabulary for " + strategy, (long)imageFiles.size());
        List tasks = imageFiles.stream().map(f -> new DescriptorExtractionTask((File)f, strategy, (ProgressReporter)progressMonitor)).collect(Collectors.toList());
        ArrayList<double[]> descriptors = new ArrayList<double[]>();
        try {
            List descriptorFutures = executor.invokeAll(tasks);
            for (Future future : descriptorFutures) {
                descriptors.addAll((Collection)future.get());
            }
            executor.shutdown();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
        LOGGER.info("Clustering {} descriptors", (Object)descriptors.size());
        StopWatch stopWatch = new StopWatch();
        Collection<Cluster> clusters = clusterer.cluster(descriptors);
        LOGGER.info("Clustering took {}", (Object)stopWatch);
        List<double[]> centroidPoints = clusters.stream().map(c -> c.center()).collect(Collectors.toList());
        return new PoiFeatureExtractor(strategy, centroidPoints);
    }

    public static PoiFeatureExtractor loadVocabulary(DescriptorExtractor strategy, File vocabularyFile) throws IOException {
        List<double[]> clusters;
        try (Stream<String> lines = Files.lines(vocabularyFile.toPath());){
            clusters = lines.map(line -> {
                String[] split = line.split(";");
                double[] values = new double[split.length];
                for (int i = 0; i < split.length; ++i) {
                    values[i] = Double.parseDouble(split[i]);
                }
                return values;
            }).collect(Collectors.toList());
        }
        LOGGER.info("Loaded {} clusters from {}", (Object)clusters.size(), (Object)vocabularyFile);
        return new PoiFeatureExtractor(strategy, clusters);
    }

    private PoiFeatureExtractor(DescriptorExtractor strategy, List<double[]> clusters) {
        this.strategy = strategy;
        this.clusters = clusters;
    }

    @Override
    public FeatureVector extract(BufferedImage image) {
        EuclideanDistance distanceMeasure = new EuclideanDistance();
        int[] histogram = new int[this.clusters.size()];
        BufferedImage greyscaleImage = ImageUtils.getGrayscaleImage(image);
        List<double[]> descriptors = this.strategy.extract(greyscaleImage);
        for (double[] featurePoint : descriptors) {
            int currentCentroidIdx = 0;
            int closestCentroidIdx = 0;
            double closestDistance = 3.4028234663852886E38;
            for (double[] centroidPoint : this.clusters) {
                double distance = distanceMeasure.compute(featurePoint, centroidPoint);
                if (distance < closestDistance) {
                    closestDistance = distance;
                    closestCentroidIdx = currentCentroidIdx;
                }
                ++currentCentroidIdx;
            }
            int n = closestCentroidIdx;
            histogram[n] = histogram[n] + 1;
        }
        return this.createBagOfWordsFeature(histogram);
    }

    private FeatureVector createBagOfWordsFeature(int[] histogram) {
        InstanceBuilder instanceBuilder = new InstanceBuilder();
        for (int i = 0; i < histogram.length; ++i) {
            instanceBuilder.set(this.getFeatureName(i), histogram[i]);
        }
        return instanceBuilder.create();
    }

    private String getFeatureName(int i) {
        return this.strategy + "-" + (i + 1) + "/" + this.clusters.size();
    }

    public void writeVocabularyToFile(File vocabularyFile) throws IOException {
        List lines = this.clusters.stream().map(d -> Arrays.stream(d).mapToObj(String::valueOf).collect(Collectors.joining(";"))).collect(Collectors.toList());
        Files.write(vocabularyFile.toPath(), lines, StandardOpenOption.CREATE_NEW);
    }

    private static final class DescriptorExtractionTask
    implements Callable<List<double[]>> {
        private final File imageFile;
        private final DescriptorExtractor strategy;
        private final ProgressReporter progress;

        DescriptorExtractionTask(File imageFile, DescriptorExtractor strategy, ProgressReporter progress) {
            this.imageFile = imageFile;
            this.strategy = strategy;
            this.progress = progress;
        }

        @Override
        public List<double[]> call() throws Exception {
            BufferedImage image = ImageHandler.load((File)this.imageFile);
            BufferedImage greyscaleImage = ImageUtils.getGrayscaleImage(image);
            List<double[]> result = this.strategy.extract(greyscaleImage);
            this.progress.increment();
            return result;
        }
    }
}

