/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.features;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.media.jai.KernelJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.DilateDescriptor;
import ws.palladian.core.FeatureVector;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.extraction.multimedia.ImageHandler;
import ws.palladian.features.FeatureExtractor;
import ws.palladian.helper.collection.CollectionHelper;
import ws.palladian.helper.math.SlimStats;

public enum RegionFeatureExtractor implements FeatureExtractor
{
    REGION;


    @Override
    public FeatureVector extract(BufferedImage image) {
        InstanceBuilder instanceBuilder = new InstanceBuilder();
        float[] floats = new float[25];
        for (int i = 0; i < 25; ++i) {
            floats[i] = 1.0f;
        }
        RenderedOp dilateOperation = DilateDescriptor.create((RenderedImage)image, (KernelJAI)new KernelJAI(5, 5, floats), null);
        BufferedImage dilatedImage = dilateOperation.getAsBufferedImage();
        int squareSize = Math.min(image.getWidth(), image.getHeight()) / 5;
        int xOffset = image.getWidth() / 2 - squareSize / 2;
        int yOffset = image.getHeight() / 2 - squareSize / 2;
        BufferedImage subimage = dilatedImage.getSubimage(xOffset, yOffset, squareSize, squareSize);
        LinkedHashMap mainImageColorFrequencies = ImageHandler.getColorFrequencies((BufferedImage)dilatedImage);
        Color mainBackgroundColor = (Color)mainImageColorFrequencies.keySet().iterator().next();
        LinkedHashMap colorFrequencies = ImageHandler.getColorFrequencies((BufferedImage)subimage);
        if (colorFrequencies.size() > 1) {
            colorFrequencies.remove(mainBackgroundColor);
        }
        LinkedHashMap cornerColors = new LinkedHashMap();
        LinkedHashMap topLeft = ImageHandler.getColorFrequencies((BufferedImage)dilatedImage.getSubimage(0, 0, 10, 10));
        LinkedHashMap topRight = ImageHandler.getColorFrequencies((BufferedImage)dilatedImage.getSubimage(dilatedImage.getWidth() - 10, 0, 10, 10));
        LinkedHashMap bottomLeft = ImageHandler.getColorFrequencies((BufferedImage)dilatedImage.getSubimage(0, dilatedImage.getHeight() - 10, 10, 10));
        LinkedHashMap bottomRight = ImageHandler.getColorFrequencies((BufferedImage)dilatedImage.getSubimage(dilatedImage.getWidth() - 10, dilatedImage.getHeight() - 10, 10, 10));
        cornerColors.putAll(topLeft);
        cornerColors.putAll(topRight);
        cornerColors.putAll(bottomLeft);
        cornerColors.putAll(bottomRight);
        for (Map.Entry colorEntry : cornerColors.entrySet()) {
            if ((Integer)colorEntry.getValue() <= 2 || colorFrequencies.size() <= 1) continue;
            colorFrequencies.remove(colorEntry.getKey());
        }
        for (int x = 0; x < dilatedImage.getWidth(); ++x) {
            for (int y = 0; y < dilatedImage.getHeight(); ++y) {
                Color color = new Color(dilatedImage.getRGB(x, y));
                if (colorFrequencies.containsKey(color)) {
                    dilatedImage.setRGB(x, y, Color.WHITE.getRGB());
                    continue;
                }
                dilatedImage.setRGB(x, y, Color.BLACK.getRGB());
            }
        }
        LinkedHashMap regions = new LinkedHashMap();
        int numberOfMainRegions = 0;
        int pixelsForMainRegion = (int)(5.0E-4 * (double)dilatedImage.getWidth() * (double)dilatedImage.getHeight());
        SlimStats slimStats = new SlimStats();
        for (int x = 0; x < dilatedImage.getWidth(); ++x) {
            for (int y = 0; y < dilatedImage.getHeight(); ++y) {
                Color color = new Color(dilatedImage.getRGB(x, y));
                if (!color.equals(Color.WHITE)) continue;
                Color rc = ImageHandler.getRandomColor();
                HashSet pixels = new HashSet();
                ImageHandler.floodFill((BufferedImage)dilatedImage, (int)x, (int)y, (Color)color, (Color)rc, pixels);
                regions.put(pixels, pixels.size());
                if (pixels.size() > pixelsForMainRegion) {
                    ++numberOfMainRegions;
                }
                slimStats.add((Number)pixels.size());
            }
        }
        if (slimStats.getCount() == 0) {
            slimStats.add((Number)0);
        }
        Map setIntegerMap = CollectionHelper.sortByValue(regions, (CollectionHelper.Order)CollectionHelper.Order.DESCENDING);
        Rectangle rectangle = null;
        Iterator iterator = setIntegerMap.keySet().iterator();
        if (iterator.hasNext()) {
            Set points = (Set)iterator.next();
            for (Point point : points) {
                if (rectangle == null) {
                    rectangle = new Rectangle(point);
                    continue;
                }
                rectangle.add(point);
            }
        }
        if (rectangle == null) {
            rectangle = new Rectangle(1, 1, 1, 1);
        }
        instanceBuilder.set("number_regions", regions.size());
        instanceBuilder.set("number_main_regions", numberOfMainRegions);
        instanceBuilder.set("mean_region_size", slimStats.getMean());
        instanceBuilder.set("main_region_size", slimStats.getMax());
        instanceBuilder.set("main_region_width", (double)(rectangle.width + 1) / (double)dilatedImage.getWidth());
        instanceBuilder.set("main_region_height", (double)(rectangle.height + 1) / (double)dilatedImage.getHeight());
        instanceBuilder.set("main_region_dominance", slimStats.getMax() / (double)(dilatedImage.getWidth() * dilatedImage.getHeight()));
        instanceBuilder.set("main_region_coverage", slimStats.getMax() / (double)((rectangle.width + 1) * (rectangle.height + 1)));
        return instanceBuilder.create();
    }
}

