/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.features;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Objects;
import org.apache.commons.math3.util.FastMath;
import ws.palladian.core.FeatureVector;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.features.FeatureExtractor;
import ws.palladian.features.color.ColorExtractor;
import ws.palladian.utils.ImageUtils;

public class SymmetryFeatureExtractor
implements FeatureExtractor {
    private final ColorExtractor[] extractors;

    public SymmetryFeatureExtractor(ColorExtractor ... extractors) {
        this.extractors = Objects.requireNonNull(extractors, "extractors must not be null");
    }

    @Override
    public FeatureVector extract(BufferedImage image) {
        InstanceBuilder instanceBuilder = new InstanceBuilder();
        int[] rgbImage = ImageUtils.getRGB(image);
        int[] flippedVertically = ImageUtils.getRGB(ImageUtils.flipVertically(image));
        int[] flippedHorizontally = ImageUtils.getRGB(ImageUtils.flipHorizontally(image));
        int[] flippedBoth = ImageUtils.getRGB(ImageUtils.flipVertically(ImageUtils.flipHorizontally(image)));
        int[] rotated180 = ImageUtils.getRGB(ImageUtils.rotate180(image));
        for (ColorExtractor extractor : this.extractors) {
            double simHorizontal = SymmetryFeatureExtractor.similarity(rgbImage, flippedVertically, extractor);
            double simVertical = SymmetryFeatureExtractor.similarity(rgbImage, flippedHorizontally, extractor);
            double simBoth = SymmetryFeatureExtractor.similarity(rgbImage, flippedBoth, extractor);
            double simRotated = SymmetryFeatureExtractor.similarity(rgbImage, rotated180, extractor);
            String extractorName = extractor.toString();
            instanceBuilder.set("symmetry-horizontal-" + extractorName, simHorizontal);
            instanceBuilder.set("symmetry-vertical-" + extractorName, simVertical);
            instanceBuilder.set("symmetry-both-" + extractorName, simBoth);
            instanceBuilder.set("symmetry-180-rotated-" + extractorName, simRotated);
        }
        return instanceBuilder.create();
    }

    public static double similarity(int[] rgbImage1, int[] rgbImage2, ColorExtractor extractor) {
        int r = 2;
        double squaredError = 0.0;
        for (int idx = 0; idx < rgbImage1.length; ++idx) {
            int value1 = extractor.extractValue(new Color(rgbImage1[idx]));
            int value2 = extractor.extractValue(new Color(rgbImage2[idx]));
            squaredError += FastMath.pow((double)((double)Math.abs(value1 - value2) / 255.0), (int)2);
        }
        return 1.0 - FastMath.pow((double)(squaredError / (double)rgbImage1.length), (double)0.5);
    }
}

