/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.fisheries.utils.hash;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.imgscalr.Scalr;
import ws.palladian.kaggle.fisheries.utils.hash.HashUtil;
import ws.palladian.kaggle.fisheries.utils.hash.ImageHash;
import ws.palladian.utils.ImageUtils;

public class AverageHash
implements ImageHash {
    private static final int WIDTH = 8;
    private static final int HEIGHT = 8;

    @Override
    public String hash(BufferedImage image) {
        BufferedImage processedImage = Scalr.resize((BufferedImage)image, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)8, (int)8, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_GRAYSCALE});
        int[] rgb = ImageUtils.getRGB(processedImage);
        double meanValue = Arrays.stream(rgb).map(v -> v & 0xFF).average().getAsDouble();
        String bitString = Arrays.stream(ImageUtils.getRGB(processedImage)).mapToObj(v -> (double)(v & 0xFF) > meanValue ? "1" : "0").collect(Collectors.joining());
        return HashUtil.toHex(bitString, 16);
    }
}

