/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.fisheries.utils.hash;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import ws.palladian.kaggle.fisheries.utils.hash.ImageHash;
import ws.palladian.utils.ImageUtils;

public class Blockhash
implements ImageHash {
    private static float median(int[] data) {
        int[] mdarr = new int[data.length];
        System.arraycopy(data, 0, mdarr, 0, data.length);
        Arrays.sort(mdarr);
        if (mdarr.length % 2 == 0) {
            return (float)(mdarr[mdarr.length / 2] + mdarr[mdarr.length / 2 + 1]) / 2.0f;
        }
        return mdarr[(int)Math.floor(mdarr.length / 2)];
    }

    private static void translate_blocks_to_bits(int[] blocks, int pixels_per_block) {
        int half_block_value = pixels_per_block * 256 * 3 / 2;
        int bandsize = blocks.length / 4;
        for (int i = 0; i < 4; ++i) {
            float m = Blockhash.median(Arrays.copyOfRange(blocks, i * bandsize, (i + 1) * bandsize));
            for (int j = i * bandsize; j < (i + 1) * bandsize; ++j) {
                int v = blocks[j];
                blocks[j] = (float)v > m || Math.abs((float)v - m) < 1.0f && m > (float)half_block_value ? 1 : 0;
            }
        }
    }

    private static String bits_to_hexhash(int[] bitsArray) {
        StringBuilder hex = new StringBuilder();
        for (int i = 0; i < bitsArray.length; i += 4) {
            int decimal = 0;
            for (int j = 0; j < 4; ++j) {
                decimal += bitsArray[i + 3 - j] << j;
            }
            hex.append(Integer.toString(decimal, 16));
        }
        return hex.toString();
    }

    private static String bmvbhash_even(ImageData data, int bits) {
        int blocksize_x = (int)Math.floor((float)data.width / (float)bits);
        int blocksize_y = (int)Math.floor((float)data.height / (float)bits);
        int[] result = new int[bits * bits];
        for (int y = 0; y < bits; ++y) {
            for (int x = 0; x < bits; ++x) {
                int total = 0;
                for (int iy = 0; iy < blocksize_y; ++iy) {
                    for (int ix = 0; ix < blocksize_x; ++ix) {
                        int cy = y * blocksize_y + iy;
                        int cx = x * blocksize_x + ix;
                        int ii = (cy * data.width + cx) * 4;
                        int alpha = data.data[ii + 3];
                        if (alpha == 0) {
                            total += 765;
                            continue;
                        }
                        total += data.data[ii] + data.data[ii + 1] + data.data[ii + 2];
                    }
                }
                result[y * bits + x] = total;
            }
        }
        Blockhash.translate_blocks_to_bits(result, blocksize_x * blocksize_y);
        return Blockhash.bits_to_hexhash(result);
    }

    private static String bmvbhash(ImageData data, int bits) {
        int i;
        boolean even_y;
        int[] result = new int[bits * bits];
        int[][] blocks = new int[bits][];
        boolean even_x = data.width % bits == 0;
        boolean bl = even_y = data.height % bits == 0;
        if (even_x && even_y) {
            return Blockhash.bmvbhash_even(data, bits);
        }
        for (i = 0; i < bits; ++i) {
            blocks[i] = new int[bits];
        }
        float block_width = (float)data.width / (float)bits;
        float block_height = (float)data.height / (float)bits;
        for (int y = 0; y < data.height; ++y) {
            float weight_bottom;
            float weight_top;
            int block_top;
            int block_bottom;
            if (even_y) {
                block_top = block_bottom = (int)Math.floor((float)y / block_height);
                weight_top = 1.0f;
                weight_bottom = 0.0f;
            } else {
                float y_mod = (float)(y + 1) % block_height;
                float y_frac = y_mod - (float)((int)Math.floor(y_mod));
                float y_int = y_mod - y_frac;
                weight_top = 1.0f - y_frac;
                weight_bottom = y_frac;
                if (y_int > 0.0f || y + 1 == data.height) {
                    block_top = block_bottom = (int)Math.floor((float)y / block_height);
                } else {
                    block_top = (int)Math.floor((float)y / block_height);
                    block_bottom = (int)Math.ceil((float)y / block_height);
                }
            }
            for (int x = 0; x < data.width; ++x) {
                float weight_right;
                float weight_left;
                int block_left;
                int block_right;
                int ii = (y * data.width + x) * 4;
                float alpha = data.data[ii + 3];
                float avgvalue = alpha == 0.0f ? 765.0f : (float)(data.data[ii] + data.data[ii + 1] + data.data[ii + 2]);
                if (even_x) {
                    block_left = block_right = (int)Math.floor((float)x / block_width);
                    weight_left = 1.0f;
                    weight_right = 0.0f;
                } else {
                    float x_mod = (float)(x + 1) % block_width;
                    float x_frac = x_mod - (float)((int)Math.floor(x_mod));
                    float x_int = x_mod - x_frac;
                    weight_left = 1.0f - x_frac;
                    weight_right = x_frac;
                    if (x_int > 0.0f || x + 1 == data.width) {
                        block_left = block_right = (int)Math.floor((float)x / block_width);
                    } else {
                        block_left = (int)Math.floor((float)x / block_width);
                        block_right = (int)Math.ceil((float)x / block_width);
                    }
                }
                int[] nArray = blocks[block_top];
                int n = block_left;
                nArray[n] = (int)((float)nArray[n] + avgvalue * weight_top * weight_left);
                int[] nArray2 = blocks[block_top];
                int n2 = block_right;
                nArray2[n2] = (int)((float)nArray2[n2] + avgvalue * weight_top * weight_right);
                int[] nArray3 = blocks[block_bottom];
                int n3 = block_left;
                nArray3[n3] = (int)((float)nArray3[n3] + avgvalue * weight_bottom * weight_left);
                int[] nArray4 = blocks[block_bottom];
                int n4 = block_right;
                nArray4[n4] = (int)((float)nArray4[n4] + avgvalue * weight_bottom * weight_right);
            }
        }
        for (i = 0; i < bits; ++i) {
            for (int j = 0; j < bits; ++j) {
                result[i * bits + j] = blocks[i][j];
            }
        }
        Blockhash.translate_blocks_to_bits(result, (int)(block_width * block_height));
        return Blockhash.bits_to_hexhash(result);
    }

    public static String blockhashData(BufferedImage image, int bits, int method) {
        ImageData imgData = new ImageData(image);
        if (method == 1) {
            return Blockhash.bmvbhash_even(imgData, bits);
        }
        if (method == 2) {
            return Blockhash.bmvbhash(imgData, bits);
        }
        throw new IllegalArgumentException("Bad hashing method");
    }

    @Override
    public String hash(BufferedImage image) {
        return Blockhash.blockhashData(image, 16, 2);
    }

    private static final class ImageData {
        final int width;
        final int height;
        final int[] data;

        ImageData(BufferedImage image) {
            this.width = image.getWidth();
            this.height = image.getHeight();
            this.data = new int[this.width * this.height * 4];
            int[] rgb = ImageUtils.getRGB(image);
            for (int i = 0; i < rgb.length; ++i) {
                Color color = new Color(rgb[i], true);
                int idx = 4 * i;
                this.data[idx++] = color.getRed();
                this.data[idx++] = color.getGreen();
                this.data[idx++] = color.getBlue();
                this.data[idx++] = color.getAlpha();
            }
        }
    }
}

