/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.fisheries.utils.hash;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import org.imgscalr.Scalr;
import ws.palladian.kaggle.fisheries.utils.hash.HashUtil;
import ws.palladian.kaggle.fisheries.utils.hash.ImageHash;

public class GradientHash
implements ImageHash {
    private static final int WIDTH = 8;
    private static final int HEIGHT = 8;

    @Override
    public String hash(BufferedImage image) {
        BufferedImage processedImage = Scalr.resize((BufferedImage)image, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)9, (int)8, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_GRAYSCALE});
        StringBuilder bitString = new StringBuilder();
        for (int xIdx = 0; xIdx < 8; ++xIdx) {
            for (int yIdx = 0; yIdx < 8; ++yIdx) {
                int rightRGB;
                int currentRGB = processedImage.getRGB(xIdx, yIdx) & 0xFF;
                bitString.append(currentRGB < (rightRGB = processedImage.getRGB(xIdx + 1, yIdx) & 0xFF) ? "1" : "0");
            }
        }
        return HashUtil.toHex(bitString, 16);
    }
}

