/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.aggregation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ws.palladian.kaggle.restaurants.aggregation.AggregationStrategy;
import ws.palladian.kaggle.restaurants.dataset.Label;
import ws.palladian.kaggle.restaurants.utils.DependencyMatrix;
import ws.palladian.kaggle.restaurants.utils.DependencyMatrixBuilder;

public class DependencyConsultationAggregationStrategy
implements AggregationStrategy {
    private DependencyMatrix dependencyMatrix = new DependencyMatrixBuilder().buildMatrix();

    @Override
    public Map<Label, Double> aggregate(Collection<Map<Label, Double>> classifiedImages) {
        HashMap<Label, Double> result = new HashMap<Label, Double>();
        for (Label label : Label.values()) {
            result.put(label, 0.0);
        }
        double maxScore = 1.0;
        for (Map<Label, Double> classifiedImage : classifiedImages) {
            for (Map.Entry<Label, Double> labelProbability : classifiedImage.entrySet()) {
                Label label = labelProbability.getKey();
                Double probability = labelProbability.getValue();
                Double prior = this.dependencyMatrix.getPrior(label);
                Double score = prior * probability;
                for (Map.Entry<Label, Double> otherLabelProbability : classifiedImage.entrySet()) {
                    Label otherLabel = otherLabelProbability.getKey();
                    if (otherLabel == label) continue;
                    Double otherPrior = this.dependencyMatrix.getPrior(otherLabel);
                    Double otherProbability = otherLabelProbability.getValue();
                    Double dependency = this.dependencyMatrix.getDependency(otherLabel, label);
                    score = score + otherPrior * dependency * otherProbability;
                }
                Double currentScore = (Double)result.get((Object)labelProbability.getKey());
                Double newScore = currentScore + score;
                result.put(labelProbability.getKey(), newScore);
                if (!(newScore > maxScore)) continue;
                maxScore = newScore;
            }
        }
        for (Label label : Label.values()) {
            result.put(label, (Double)result.get((Object)label) / (maxScore * (double)classifiedImages.size()));
        }
        return result;
    }
}

