/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.aggregation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ws.palladian.helper.collection.Bag;
import ws.palladian.kaggle.restaurants.aggregation.AggregationStrategy;
import ws.palladian.kaggle.restaurants.dataset.Label;

public class MajorityAggregationStrategy
implements AggregationStrategy {
    private final Map<Label, Double> thresholds;

    public MajorityAggregationStrategy(Map<Label, Double> thresholds) {
        this.thresholds = thresholds;
    }

    public MajorityAggregationStrategy(double threshold) {
        this.thresholds = new HashMap<Label, Double>();
        for (Label label : Label.values()) {
            this.thresholds.put(label, threshold);
        }
    }

    @Override
    public Map<Label, Double> aggregate(Collection<Map<Label, Double>> classifiedImages) {
        Bag votes = Bag.create();
        for (Map<Label, Double> classifiedImage : classifiedImages) {
            for (Map.Entry<Label, Double> labelProbability : classifiedImage.entrySet()) {
                Double threshold = this.thresholds.get((Object)labelProbability.getKey());
                if (!(labelProbability.getValue() > threshold)) continue;
                votes.add((Object)labelProbability.getKey());
            }
        }
        HashMap<Label, Double> result = new HashMap<Label, Double>();
        for (Map.Entry labelCount : votes.unique()) {
            Double score = (double)((Integer)labelCount.getValue()).intValue() / (double)classifiedImages.size();
            result.put((Label)((Object)labelCount.getKey()), score);
        }
        return result;
    }
}

