/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.aggregation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ws.palladian.helper.collection.Bag;
import ws.palladian.kaggle.restaurants.aggregation.AggregationStrategy;
import ws.palladian.kaggle.restaurants.dataset.Label;

public class UnanimousAggregationStrategy
implements AggregationStrategy {
    private final double threshold;

    public UnanimousAggregationStrategy(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public Map<Label, Double> aggregate(Collection<Map<Label, Double>> classifiedImages) {
        HashMap<Label, Double> result = new HashMap<Label, Double>();
        for (Label label : Label.values()) {
            result.put(label, 0.0);
        }
        Bag votes = Bag.create();
        for (Map<Label, Double> classifiedImage : classifiedImages) {
            for (Map.Entry<Label, Double> labelProbability : classifiedImage.entrySet()) {
                if (!(labelProbability.getValue() > this.threshold)) continue;
                votes.add((Object)labelProbability.getKey());
                Double currentProbabilitySum = (Double)result.get((Object)labelProbability.getKey());
                result.put(labelProbability.getKey(), currentProbabilitySum + labelProbability.getValue());
            }
        }
        for (Label label : Label.values()) {
            if (votes.count((Object)label) == classifiedImages.size()) {
                result.put(label, (Double)result.get((Object)label) / (double)classifiedImages.size());
                continue;
            }
            result.put(label, 0.0);
        }
        return result;
    }
}

