/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.dataset;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import ws.palladian.core.Instance;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.core.value.Value;
import ws.palladian.dataset.ImageValue;
import ws.palladian.helper.ProgressMonitor;
import ws.palladian.helper.ProgressReporter;
import ws.palladian.helper.collection.AbstractIterator;
import ws.palladian.helper.functional.Predicates;
import ws.palladian.helper.io.FileHelper;

public class DirectoryDatasetReader
implements Iterable<Instance> {
    private final File directory;
    private List<File> imageFiles;

    public DirectoryDatasetReader(File directory) {
        this(directory, Predicates.ALL);
    }

    public DirectoryDatasetReader(File directory, Predicate<? super File> filter) {
        this.directory = directory;
        this.imageFiles = FileHelper.getFiles((File)directory, (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.fileExtension((String[])new String[]{"jpg"}), filter}), (Predicate)Predicates.ALL);
    }

    @Override
    public Iterator<Instance> iterator() {
        final Iterator<File> fileIterator = this.imageFiles.iterator();
        ProgressMonitor progressReporter = new ProgressMonitor();
        progressReporter.startTask(this.directory.toString(), (long)this.imageFiles.size());
        return new AbstractIterator<Instance>((ProgressReporter)progressReporter){
            final /* synthetic */ ProgressReporter val$progressReporter;
            {
                this.val$progressReporter = progressReporter;
            }

            protected Instance getNext() throws AbstractIterator.Finished {
                if (fileIterator.hasNext()) {
                    File imageFile = (File)fileIterator.next();
                    String category = imageFile.getParentFile().getName().toString();
                    this.val$progressReporter.increment();
                    return new InstanceBuilder().set("image", (Value)new ImageValue(imageFile)).create(category);
                }
                throw FINISHED;
            }
        };
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.directory + "]";
    }

    public List<File> getImageFiles() {
        return Collections.unmodifiableList(this.imageFiles);
    }
}

