/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.dataset;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import ws.palladian.core.Instance;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.core.dataset.AbstractDataset;
import ws.palladian.core.dataset.FeatureInformation;
import ws.palladian.core.dataset.FeatureInformationBuilder;
import ws.palladian.core.value.ImmutableStringValue;
import ws.palladian.core.value.Value;
import ws.palladian.dataset.ImageValue;
import ws.palladian.helper.collection.AbstractIterator;
import ws.palladian.helper.io.CloseableIterator;
import ws.palladian.helper.io.CloseableIteratorAdapter;
import ws.palladian.helper.io.FileHelper;

public class YelpKaggleTestsetReader
extends AbstractDataset {
    private final List<File> files;

    public YelpKaggleTestsetReader(File testImagePath) {
        Objects.requireNonNull(testImagePath, "testImagePath must not be null");
        this.files = Arrays.stream(testImagePath.listFiles()).filter(f -> f.getName().endsWith("jpg")).collect(Collectors.toList());
    }

    public CloseableIterator<Instance> iterator() {
        return new CloseableIteratorAdapter((Iterator)new AbstractIterator<Instance>(){
            final Iterator<File> fileIterator;
            {
                this.fileIterator = YelpKaggleTestsetReader.this.files.iterator();
            }

            protected Instance getNext() throws AbstractIterator.Finished {
                if (this.fileIterator.hasNext()) {
                    File file = this.fileIterator.next();
                    InstanceBuilder builder = new InstanceBuilder();
                    builder.set("image", (Value)new ImageValue(file));
                    builder.set("photoId", FileHelper.getFileName((String)file.getAbsolutePath()).replace(".jpg", ""));
                    return builder.create(true);
                }
                throw FINISHED;
            }
        });
    }

    public FeatureInformation getFeatureInformation() {
        FeatureInformationBuilder builder = new FeatureInformationBuilder();
        builder.set("image", ImageValue.class);
        builder.set("photoId", ImmutableStringValue.class);
        return builder.create();
    }

    public long size() {
        return this.files.size();
    }
}

