/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.experiments;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.media.jai.KernelJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.DilateDescriptor;
import ws.palladian.core.FeatureVector;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.extraction.multimedia.ImageHandler;
import ws.palladian.helper.collection.CollectionHelper;
import ws.palladian.helper.math.SlimStats;

public class RegionDetector {
    /*
     * WARNING - void declaration
     */
    public static FeatureVector fillMainShape(BufferedImage image) {
        void var18_26;
        InstanceBuilder instanceBuilder = new InstanceBuilder();
        float[] floats = new float[25];
        for (int i = 0; i < 25; ++i) {
            floats[i] = 1.0f;
        }
        RenderedOp dilateOperation = DilateDescriptor.create((RenderedImage)image, (KernelJAI)new KernelJAI(5, 5, floats), null);
        BufferedImage dilatedImage = dilateOperation.getAsBufferedImage();
        ImageHandler.saveImage((BufferedImage)dilatedImage, (String)"data/temp/pics/dilated.bmp");
        ImageHandler.saveImage((BufferedImage)dilatedImage, (String)"data/temp/pics/dilated.jpg");
        int squareSize = Math.min(image.getWidth(), image.getHeight()) / 5;
        int xOffset = image.getWidth() / 2 - squareSize / 2;
        int yOffset = image.getHeight() / 2 - squareSize / 2;
        BufferedImage subimage = dilatedImage.getSubimage(xOffset, yOffset, squareSize, squareSize);
        LinkedHashMap mainImageColorFrequencies = ImageHandler.getColorFrequencies((BufferedImage)dilatedImage);
        Color mainBackgroundColor = (Color)mainImageColorFrequencies.keySet().iterator().next();
        System.out.println("most frequent in image: " + ImageHandler.rgbToHex((Color)mainBackgroundColor));
        LinkedHashMap colorFrequencies = ImageHandler.getColorFrequencies((BufferedImage)subimage);
        colorFrequencies.remove(mainBackgroundColor);
        LinkedHashMap cornerColors = new LinkedHashMap();
        LinkedHashMap topLeft = ImageHandler.getColorFrequencies((BufferedImage)dilatedImage.getSubimage(0, 0, 10, 10));
        LinkedHashMap topRight = ImageHandler.getColorFrequencies((BufferedImage)dilatedImage.getSubimage(dilatedImage.getWidth() - 10, 0, 10, 10));
        LinkedHashMap bottomLeft = ImageHandler.getColorFrequencies((BufferedImage)dilatedImage.getSubimage(0, dilatedImage.getHeight() - 10, 10, 10));
        LinkedHashMap bottomRight = ImageHandler.getColorFrequencies((BufferedImage)dilatedImage.getSubimage(dilatedImage.getWidth() - 10, dilatedImage.getHeight() - 10, 10, 10));
        cornerColors.putAll(topLeft);
        cornerColors.putAll(topRight);
        cornerColors.putAll(bottomLeft);
        cornerColors.putAll(bottomRight);
        for (Color color : cornerColors.keySet()) {
            colorFrequencies.remove(color);
        }
        for (Map.Entry entry : colorFrequencies.entrySet()) {
            System.out.println(ImageHandler.rgbToHex((Color)((Color)entry.getKey())) + " : " + entry.getValue());
        }
        ImageHandler.saveImage((BufferedImage)subimage, (String)"data/temp/pics/subImage.bmp");
        ImageHandler.saveImage((BufferedImage)subimage, (String)"data/temp/pics/subImage.jpg");
        for (int x = 0; x < dilatedImage.getWidth(); ++x) {
            for (int i = 0; i < dilatedImage.getHeight(); ++i) {
                Color color = new Color(dilatedImage.getRGB(x, i));
                if (colorFrequencies.containsKey(color)) {
                    dilatedImage.setRGB(x, i, Color.WHITE.getRGB());
                    continue;
                }
                dilatedImage.setRGB(x, i, Color.BLACK.getRGB());
            }
        }
        ImageHandler.saveImage((BufferedImage)dilatedImage, (String)"data/temp/pics/surfaces.bmp");
        ImageHandler.saveImage((BufferedImage)dilatedImage, (String)"data/temp/pics/surfaces.jpg");
        LinkedHashMap regions = new LinkedHashMap();
        boolean bl = false;
        int pixelsForMainRegion = (int)(5.0E-4 * (double)dilatedImage.getWidth() * (double)dilatedImage.getHeight());
        SlimStats slimStats = new SlimStats();
        for (int x = 0; x < dilatedImage.getWidth(); ++x) {
            for (int y = 0; y < dilatedImage.getHeight(); ++y) {
                Color color = new Color(dilatedImage.getRGB(x, y));
                if (!color.equals(Color.WHITE)) continue;
                Color rc = ImageHandler.getRandomColor();
                HashSet pixels = new HashSet();
                ImageHandler.floodFill((BufferedImage)dilatedImage, (int)x, (int)y, (Color)color, (Color)rc, pixels);
                regions.put(pixels, pixels.size());
                if (pixels.size() > pixelsForMainRegion) {
                    ++var18_26;
                }
                slimStats.add((Number)pixels.size());
            }
        }
        ImageHandler.saveImage((BufferedImage)dilatedImage, (String)"data/temp/pics/all-shapes.bmp");
        ImageHandler.saveImage((BufferedImage)dilatedImage, (String)"data/temp/pics/all-shapes.jpg");
        System.out.println("============================");
        Map setIntegerMap = CollectionHelper.sortByValue(regions, (CollectionHelper.Order)CollectionHelper.Order.DESCENDING);
        boolean first = true;
        Rectangle rectangle = null;
        for (Set points : setIntegerMap.keySet()) {
            if (!first) {
                for (Point point : points) {
                    dilatedImage.setRGB(point.x, point.y, Color.BLACK.getRGB());
                }
            } else {
                for (Point point : points) {
                    if (rectangle == null) {
                        rectangle = new Rectangle(point);
                        continue;
                    }
                    rectangle.add(point);
                }
            }
            System.out.println("pixels: " + regions.get(points));
            first = false;
        }
        BufferedImage croppedImage = dilatedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        ImageHandler.saveImage((BufferedImage)croppedImage, (String)"data/temp/pics/one-shape.bmp");
        ImageHandler.saveImage((BufferedImage)croppedImage, (String)"data/temp/pics/one-shape.jpg");
        instanceBuilder.set("number_regions", regions.size());
        instanceBuilder.set("number_main_regions", (int)var18_26);
        instanceBuilder.set("min_region_size", slimStats.getMin());
        instanceBuilder.set("max_region_size", slimStats.getMax());
        instanceBuilder.set("mean_region_size", slimStats.getMean());
        instanceBuilder.set("median_region_size", slimStats.getMedian());
        instanceBuilder.set("main_region_width", rectangle.width / dilatedImage.getWidth());
        instanceBuilder.set("main_region_height", rectangle.height / dilatedImage.getHeight());
        instanceBuilder.set("main_region_dominance", slimStats.getMax() / (double)(dilatedImage.getWidth() * dilatedImage.getHeight()));
        instanceBuilder.set("main_region_coverage", slimStats.getMax() / (double)(rectangle.width * rectangle.height));
        return instanceBuilder.create();
    }

    public static void main(String[] args) {
        String n = "248744";
        BufferedImage original = ImageHandler.load((String)("data/temp/pics/" + n + ".jpg"));
        BufferedImage reduced = ImageHandler.reduceColors((BufferedImage)original, (int)8);
        ImageHandler.saveImage((BufferedImage)reduced, (String)("data/temp/pics/" + n + "-ot.png"));
        RegionDetector.fillMainShape(ImageHandler.load((String)("data/temp/pics/" + n + "-ot.png")));
    }
}

