/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.features.descriptors;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import ws.palladian.kaggle.restaurants.features.descriptors.DescriptorExtractor;
import ws.palladian.kaggle.restaurants.features.descriptors.MopsDescriptorExtractor;
import ws.palladian.kaggle.restaurants.features.descriptors.SiftDescriptorExtractor;
import ws.palladian.kaggle.restaurants.features.descriptors.SurfDescriptorExtractor;
import ws.palladian.utils.ImageUtils;

public class DescriptorExtractorUtil {
    public static void drawDescriptors(BufferedImage image, DescriptorExtractor extractor, File outputFile) throws IOException {
        BufferedImage greyscaleImage = ImageUtils.getGrayscaleImage(image);
        Graphics2D graphics = greyscaleImage.createGraphics();
        List<DescriptorExtractor.Descriptor> descriptors = extractor.extractDescriptors(greyscaleImage);
        for (DescriptorExtractor.Descriptor descriptor : descriptors) {
            descriptor.draw(graphics);
        }
        ImageIO.write((RenderedImage)greyscaleImage, "jpg", outputFile);
    }

    public static void main(String[] args) throws IOException {
        BufferedImage imageFile = ImageIO.read(new File("/Users/pk/temp/Yelp-Restaurants/train_photos/923.jpg"));
        DescriptorExtractorUtil.drawDescriptors(imageFile, SurfDescriptorExtractor.SURF, new File("/Users/pk/Desktop/test-surf.jpg"));
        DescriptorExtractorUtil.drawDescriptors(imageFile, SiftDescriptorExtractor.SIFT, new File("/Users/pk/Desktop/test-sift.jpg"));
        DescriptorExtractorUtil.drawDescriptors(imageFile, MopsDescriptorExtractor.MOPS, new File("/Users/pk/Desktop/test-mops.jpg"));
    }
}

