/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.features.descriptors;

import ij.process.ImageProcessor;
import java.util.Collection;
import java.util.Collections;
import mpicbg.ij.MOPS;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DMOPS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.palladian.kaggle.restaurants.features.descriptors.MpicbgDescriptorExtractor;

public class MopsDescriptorExtractor
extends MpicbgDescriptorExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MopsDescriptorExtractor.class);
    public static final MopsDescriptorExtractor MOPS = new MopsDescriptorExtractor();

    private MopsDescriptorExtractor() {
    }

    @Override
    protected Collection<Feature> extract(ImageProcessor processor) {
        FloatArray2DMOPS.Param param = new FloatArray2DMOPS.Param();
        param.minOctaveSize = 64;
        param.maxOctaveSize = 128;
        MOPS mops = new MOPS(new FloatArray2DMOPS(param));
        try {
            return mops.extractFeatures(processor);
        }
        catch (Exception e) {
            LOGGER.warn("Encountered {}", (Object)e.toString(), (Object)e);
            return Collections.emptySet();
        }
    }

    public String toString() {
        return "MOPS";
    }
}

