/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.features.descriptors;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.point.Point2D_F64;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import ws.palladian.kaggle.restaurants.features.descriptors.DescriptorExtractor;
import ws.palladian.kaggle.restaurants.features.descriptors.ImmutableDescriptor;

public class SurfDescriptorExtractor
implements DescriptorExtractor {
    public static final SurfDescriptorExtractor SURF = new SurfDescriptorExtractor();

    private SurfDescriptorExtractor() {
    }

    @Override
    public List<DescriptorExtractor.Descriptor> extractDescriptors(BufferedImage image) {
        ConfigFastHessian config = new ConfigFastHessian();
        DetectDescribePoint surf = FactoryDetectDescribe.surfStable((ConfigFastHessian)config, null, null, ImageUInt8.class);
        ImageUInt8 input = ConvertBufferedImage.extractImageUInt8((BufferedImage)image);
        surf.detect((ImageBase)input);
        ArrayList<DescriptorExtractor.Descriptor> descriptions = new ArrayList<DescriptorExtractor.Descriptor>();
        for (int featureIdx = 0; featureIdx < surf.getNumberOfFeatures(); ++featureIdx) {
            Point2D_F64 location = surf.getLocation(featureIdx);
            double orientation = surf.getOrientation(featureIdx);
            double radius = surf.getRadius(featureIdx);
            double[] description = ((BrightFeature)surf.getDescription((int)featureIdx)).value;
            descriptions.add(new ImmutableDescriptor(description, (int)location.x, (int)location.y, (int)radius, (int)orientation));
        }
        return descriptions;
    }

    public String toString() {
        return "SURF";
    }
}

