/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.utils;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.palladian.kaggle.restaurants.Experimenter;

public final class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Experimenter.class);
    private static final String FILE_NAME = "config.properties";
    private static final String DATA_DIRECTORY = "dataset.yelp.restaurants.data";
    private static final String SPARK_MASTER = "spark.master";
    public static Configuration CONFIG;

    public static File getDataPath(String name) {
        Objects.requireNonNull(name);
        String dataDirectoryString = CONFIG.getString(DATA_DIRECTORY);
        if (StringUtils.isEmpty((CharSequence)dataDirectoryString)) {
            throw new IllegalStateException("Property dataset.yelp.restaurants.data is not defined");
        }
        File dataDirectory = new File(dataDirectoryString);
        if (!dataDirectory.exists()) {
            LOGGER.info("{} does not exist and will be created", (Object)dataDirectory);
            if (!dataDirectory.mkdirs()) {
                throw new IllegalStateException(dataDirectory + " could not be created");
            }
        }
        if (!dataDirectory.isDirectory()) {
            throw new IllegalStateException(dataDirectory + " is not a directory");
        }
        return new File(dataDirectory, name);
    }

    public static File getFilePath(String propertyName) {
        Objects.requireNonNull(propertyName);
        String path = CONFIG.getString(propertyName);
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Property " + propertyName + " is not defined.");
        }
        return new File(path);
    }

    public static List<File> getFilePaths(String propertyName) {
        Objects.requireNonNull(propertyName);
        String[] paths = CONFIG.getStringArray(propertyName);
        return Arrays.stream(paths).map(File::new).collect(Collectors.toList());
    }

    private Config() {
    }

    static {
        try {
            URL configurationLocation = ConfigurationUtils.locate((String)FILE_NAME);
            LOGGER.info("Configuration location = {}", (Object)configurationLocation);
            CONFIG = new PropertiesConfiguration(configurationLocation);
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException();
        }
    }
}

