/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.utils;

import java.util.HashMap;
import java.util.List;
import ws.palladian.helper.collection.Bag;
import ws.palladian.helper.collection.MapMatrix;
import ws.palladian.helper.collection.Matrix;
import ws.palladian.helper.io.FileHelper;
import ws.palladian.helper.math.MathHelper;
import ws.palladian.kaggle.restaurants.utils.Config;
import ws.palladian.kaggle.restaurants.utils.DependencyMatrix;

public class DependencyMatrixBuilder {
    public DependencyMatrix buildMatrix() {
        MapMatrix matrix = new MapMatrix();
        for (int i = 0; i <= 8; ++i) {
            matrix.set((Object)i, (Object)i, (Object)0.0);
        }
        Bag counts = Bag.create();
        List strings = FileHelper.readFileToArray((String)Config.CONFIG.getString("dataset.yelp.restaurants.train.csv"));
        for (String string : strings) {
            if (string.startsWith("business_id")) continue;
            String[] split = string.split("[, ]");
            for (int i = 1; i < split.length; ++i) {
                int label1 = Integer.valueOf(split[i]);
                counts.add((Object)label1);
                for (int j = i; j < split.length; ++j) {
                    int label2 = Integer.valueOf(split[j]);
                    Double num = (Double)matrix.get((Object)label1, (Object)label2);
                    if (num == null) {
                        num = 0.0;
                    }
                    Double d = num;
                    Double d2 = num = Double.valueOf(num + 1.0);
                    matrix.set((Object)label1, (Object)label2, (Object)num);
                    matrix.set((Object)label2, (Object)label1, (Object)num);
                }
            }
        }
        System.out.println(matrix.toString());
        FileHelper.writeToFile((String)(Config.CONFIG.getString("dataset.yelp.restaurants.results") + "/matrix.tsv"), (CharSequence)matrix.toString("\t"));
        HashMap<Integer, Double> labelPriors = new HashMap<Integer, Double>();
        for (int i = 0; i <= 8; ++i) {
            for (int j = 0; j <= 8; ++j) {
                if (i == j) {
                    matrix.set((Object)i, (Object)j, (Object)((double)counts.count((Object)i) / (double)strings.size()));
                    labelPriors.put(i, (double)counts.count((Object)i) / (double)strings.size());
                    continue;
                }
                Double num = (Double)matrix.get((Object)i, (Object)j);
                num = num / (double)counts.count((Object)j);
                matrix.set((Object)i, (Object)j, (Object)MathHelper.round((double)num, (int)4));
            }
        }
        FileHelper.writeToFile((String)(Config.CONFIG.getString("dataset.yelp.restaurants.results") + "/matrix-asymmetric.tsv"), (CharSequence)matrix.toString("\t").replace(".", ","));
        return new DependencyMatrix((Matrix<Integer, Double>)matrix);
    }

    public static void main(String[] args) {
        new DependencyMatrixBuilder().buildMatrix();
    }
}

