/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.kaggle.restaurants.utils;

import ws.palladian.core.FeatureVector;
import ws.palladian.core.Instance;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.core.dataset.DatasetTransformer;
import ws.palladian.core.dataset.FeatureInformation;
import ws.palladian.core.value.NumericValue;
import ws.palladian.core.value.Value;
import ws.palladian.helper.collection.Vector;

public enum NaNInfiniteInstanceTransformer implements DatasetTransformer
{
    TRANSFORMER;


    public Instance apply(Instance input) {
        FeatureVector featureVector = input.getVector();
        InstanceBuilder builder = new InstanceBuilder().add(featureVector);
        for (Vector.VectorEntry entry : featureVector) {
            Value value = (Value)entry.value();
            if (!(value instanceof NumericValue)) continue;
            double doubleValue = ((NumericValue)value).getDouble();
            if (Double.isNaN(doubleValue)) {
                doubleValue = 0.0;
            }
            if (Double.isInfinite(doubleValue)) {
                doubleValue = 0.0;
            }
            builder.set((String)entry.key(), doubleValue);
        }
        return builder.create(input.getCategory());
    }

    public FeatureInformation getFeatureInformation(FeatureInformation featureInformation) {
        return featureInformation;
    }
}

