/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.utils;

import java.util.Objects;
import java.util.function.IntConsumer;
import org.apache.commons.lang.Validate;
import org.apache.commons.math3.util.FastMath;
import ws.palladian.helper.math.AbstractStats;
import ws.palladian.helper.math.Stats;

public class HistogramStats
extends AbstractStats {
    private final int[] numbers;
    private int count;

    public HistogramStats(int maxValue) {
        Validate.isTrue((maxValue > 0 ? 1 : 0) != 0, (String)"maxValue must be greater zero");
        this.numbers = new int[maxValue];
    }

    public HistogramStats() {
        this(256);
    }

    public Stats add(Number value) {
        Validate.notNull((Object)value, (String)"value must not be null");
        Validate.isTrue((boolean)(value instanceof Integer), (String)"value must be an Integer");
        this.add(value.intValue(), 1);
        return this;
    }

    public Stats add(int value, int times) {
        Validate.isTrue((times >= 0 ? 1 : 0) != 0, (String)"times must be greater equal zero");
        int n = value;
        this.numbers[n] = this.numbers[n] + times;
        this.count += times;
        return this;
    }

    public double getMean() {
        if (this.count == 0) {
            return Double.NaN;
        }
        return this.getSum() / (double)this.getCount();
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.momentAboutMean(2));
    }

    public double getPercentile(int p) {
        Validate.isTrue((p >= 0 && p <= 100 ? 1 : 0) != 0, (String)"p must be in range [0,100]");
        if (this.count == 0) {
            return Double.NaN;
        }
        double n = (double)p / 100.0 * (double)this.count;
        if (n == (double)((int)n)) {
            return 0.5 * this.getValueAtIndex((int)n - 1) + 0.5 * this.getValueAtIndex((int)n);
        }
        return this.getValueAtIndex((int)Math.ceil(n) - 1);
    }

    private double getValueAtIndex(int index) {
        int cumulatedIndex = 0;
        for (int i = 0; i < this.numbers.length; ++i) {
            int valueBefore = cumulatedIndex;
            if (valueBefore > index || index > (cumulatedIndex += this.numbers[i])) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    public int getCount() {
        return this.count;
    }

    public double getMin() {
        for (int i = 0; i < this.numbers.length; ++i) {
            if (this.numbers[i] <= 0) continue;
            return i;
        }
        return Double.NaN;
    }

    public double getMax() {
        for (int i = this.numbers.length - 1; i >= 0; --i) {
            if (this.numbers[i] <= 0) continue;
            return i;
        }
        return Double.NaN;
    }

    public double getSum() {
        int sum = 0;
        for (int i = 0; i < this.numbers.length; ++i) {
            sum += i * this.numbers[i];
        }
        return sum;
    }

    public double getMse() {
        throw new UnsupportedOperationException();
    }

    public double getCumulativeProbability(double t) {
        throw new UnsupportedOperationException();
    }

    public double getMode() {
        double mode = Double.NaN;
        int maxCount = 0;
        for (int i = 0; i < this.numbers.length; ++i) {
            if (this.numbers[i] <= maxCount) continue;
            maxCount = this.numbers[i];
            mode = i;
        }
        return mode;
    }

    public void iterate(IntConsumer consumer) {
        Objects.requireNonNull(consumer);
        for (int number = 0; number < this.numbers.length; ++number) {
            for (int i = 0; i < this.numbers[number]; ++i) {
                consumer.accept(number);
            }
        }
    }

    public double getSkewness() {
        double variance = this.getVariance();
        if (variance == 0.0) {
            return 0.0;
        }
        return this.momentAboutMean(3) / FastMath.pow((double)variance, (double)1.5);
    }

    public double getKurtosis() {
        double variance = this.getVariance();
        if (variance == 0.0) {
            return 0.0;
        }
        return this.momentAboutMean(4) / FastMath.pow((double)variance, (int)2) - 3.0;
    }

    public boolean isSample() {
        return false;
    }

    private double momentAboutMean(int k) {
        if (this.count == 0) {
            return Double.NaN;
        }
        double mean = this.getMean();
        double moment = 0.0;
        for (int i = 0; i < this.numbers.length; ++i) {
            moment += (double)this.numbers[i] * FastMath.pow((double)((double)i - mean), (int)k);
        }
        return moment /= (double)this.count;
    }
}

