/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.utils;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.Objects;
import javax.imageio.ImageIO;
import ws.palladian.features.color.ColorExtractor;
import ws.palladian.features.color.HSB;

public final class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage getGrayscaleImage(BufferedImage image) {
        ColorConvertOp grayscaleConv = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        BufferedImage greyscaleImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        grayscaleConv.filter(image, greyscaleImage);
        return greyscaleImage;
    }

    public static BufferedImage flipVertically(BufferedImage image) {
        return ImageUtils.flip(image, true);
    }

    public static BufferedImage flipHorizontally(BufferedImage image) {
        return ImageUtils.flip(image, false);
    }

    private static BufferedImage flip(BufferedImage image, boolean vertically) {
        AffineTransform tx;
        Objects.requireNonNull(image);
        if (vertically) {
            tx = AffineTransform.getScaleInstance(1.0, -1.0);
            tx.translate(0.0, -image.getHeight(null));
        } else {
            tx = AffineTransform.getScaleInstance(-1.0, 1.0);
            tx.translate(-image.getWidth(null), 0.0);
        }
        return ImageUtils.apply(image, tx);
    }

    private static BufferedImage apply(BufferedImage image, AffineTransform tx) {
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(image, null);
    }

    public static BufferedImage rotate180(BufferedImage image) {
        Objects.requireNonNull(image);
        return ImageUtils.apply(image, AffineTransform.getRotateInstance(Math.PI, (double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0));
    }

    public static int[] getRGB(BufferedImage image) {
        Objects.requireNonNull(image, "image must not be null");
        return image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
    }

    public static BufferedImage getGreyscale(ColorExtractor extractor, BufferedImage image) {
        Objects.requireNonNull(extractor);
        Objects.requireNonNull(image);
        WritableRaster raster = image.copyData(null);
        BufferedImage result = new BufferedImage(image.getColorModel(), raster, image.getColorModel().isAlphaPremultiplied(), null);
        int[] rgbImage = ImageUtils.getRGB(image);
        for (int xIdx = 0; xIdx < image.getWidth(); ++xIdx) {
            for (int yIdx = 0; yIdx < image.getHeight(); ++yIdx) {
                Color color = new Color(rgbImage[xIdx * image.getWidth() + yIdx]);
                int value = extractor.extractValue(color);
                int rgbValue = new Color(value, value, value).getRGB();
                result.setRGB(xIdx, yIdx, rgbValue);
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        BufferedImage image = ImageIO.read(new File("/Users/pk/Documents/workspace_4.5/kaggle-restaurants/src/test/resources/51612.jpg"));
        ImageIO.write((RenderedImage)ImageUtils.flipHorizontally(image), "jpg", new File("/Users/pk/Desktop/horizontal-flip.jpg"));
        ImageIO.write((RenderedImage)ImageUtils.flipVertically(image), "jpg", new File("/Users/pk/Desktop/vertical-flip.jpg"));
        ImageIO.write((RenderedImage)ImageUtils.rotate180(image), "jpg", new File("/Users/pk/Desktop/rotated.jpg"));
        for (HSB extractor : HSB.values()) {
            BufferedImage hImage = ImageUtils.getGreyscale(extractor, image);
            ImageIO.write((RenderedImage)hImage, "jpg", new File("/Users/pk/Desktop/" + extractor + ".jpg"));
        }
    }
}

