/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.utils;

import java.util.Objects;
import java.util.function.Predicate;
import ws.palladian.core.Instance;
import ws.palladian.core.InstanceBuilder;
import ws.palladian.core.dataset.DatasetTransformer;
import ws.palladian.core.dataset.FeatureInformation;
import ws.palladian.core.value.NumericValue;
import ws.palladian.core.value.Value;
import ws.palladian.helper.collection.Vector;

public class InstanceValueBinarizer
implements DatasetTransformer {
    private final Predicate<? super String> filter;

    public InstanceValueBinarizer(Predicate<? super String> filter) {
        this.filter = Objects.requireNonNull(filter);
    }

    public Instance apply(Instance input) {
        InstanceBuilder builder = new InstanceBuilder();
        for (Vector.VectorEntry entry : input.getVector()) {
            if (this.filter.test((String)entry.key())) {
                if (entry.value() instanceof NumericValue) {
                    boolean binary = ((NumericValue)entry.value()).getDouble() > 0.0;
                    builder.set((String)entry.key(), binary);
                    continue;
                }
                throw new IllegalArgumentException("Value " + (String)entry.key() + " is not of type " + NumericValue.class + ", but " + ((Value)entry.value()).getClass() + ", cannot binarize.");
            }
            builder.set((String)entry.key(), (Value)entry.value());
        }
        return builder.create(input.getCategory());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.filter + ")";
    }

    public FeatureInformation getFeatureInformation(FeatureInformation featureInformation) {
        return featureInformation;
    }
}

